// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.newsfeed;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.base.Likes;
import com.vk.api.sdk.objects.base.ObjectCount;
import com.vk.api.sdk.objects.base.PropertyExists;
import com.vk.api.sdk.objects.base.RepostsInfo;
import com.vk.api.sdk.objects.photos.Image;
import com.vk.api.sdk.objects.photos.PhotoSizes;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * CommentsItemTypePhoto object
 */
public class CommentsItemTypePhoto extends CommentsItemBase implements Validable {
    /**
     * Access key for the photo
     */
    @SerializedName("access_key")
    private String accessKey;

    /**
     * Album ID
     */
    @SerializedName("album_id")
    @Required
    private Integer albumId;

    /**
     * Information whether current user can comment the photo
     */
    @SerializedName("can_comment")
    private BoolInt canComment;

    @SerializedName("comments")
    private ObjectCount comments;

    /**
     * Whether photo has attached tag links
     */
    @SerializedName("has_tags")
    @Required
    private Boolean hasTags;

    /**
     * Original photo height
     */
    @SerializedName("height")
    private Integer height;

    /**
     * Returns if the photo is hidden above the wall
     */
    @SerializedName("hidden")
    private PropertyExists hidden;

    /**
     * Photo ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    @SerializedName("images")
    private List<Image> images;

    /**
     * Latitude
     */
    @SerializedName("lat")
    private Number lat;

    @SerializedName("likes")
    private Likes likes;

    /**
     * Longitude
     */
    @SerializedName("long")
    private Number lng;

    /**
     * Photo owner's ID
     * Entity: owner
     */
    @SerializedName("owner_id")
    @Required
    private Long ownerId;

    /**
     * URL of image with 2560 px width
     */
    @SerializedName("photo_256")
    private URI photo256;

    @SerializedName("place")
    private String place;

    /**
     * Real position of the photo
     */
    @SerializedName("real_offset")
    private Integer realOffset;

    @SerializedName("reposts")
    private RepostsInfo reposts;

    @SerializedName("sizes")
    private List<PhotoSizes> sizes;

    @SerializedName("square_crop")
    private String squareCrop;

    @SerializedName("tags")
    private ObjectCount tags;

    /**
     * Photo caption
     */
    @SerializedName("text")
    private String text;

    /**
     * ID of the user who have uploaded the photo
     * Entity: owner
     */
    @SerializedName("user_id")
    private Long userId;

    /**
     * Sets vertical alignment of a photo
     */
    @SerializedName("vertical_align")
    private CommentsItemTypePhotoVerticalAlign verticalAlign;

    /**
     * Original photo width
     */
    @SerializedName("width")
    private Integer width;

    public String getAccessKey() {
        return accessKey;
    }

    public CommentsItemTypePhoto setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public Integer getAlbumId() {
        return albumId;
    }

    public CommentsItemTypePhoto setAlbumId(Integer albumId) {
        this.albumId = albumId;
        return this;
    }

    public boolean canComment() {
        return canComment == BoolInt.YES;
    }

    public BoolInt getCanComment() {
        return canComment;
    }

    public ObjectCount getComments() {
        return comments;
    }

    public CommentsItemTypePhoto setComments(ObjectCount comments) {
        this.comments = comments;
        return this;
    }

    public Boolean getHasTags() {
        return hasTags;
    }

    public CommentsItemTypePhoto setHasTags(Boolean hasTags) {
        this.hasTags = hasTags;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public CommentsItemTypePhoto setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public boolean isHidden() {
        return hidden == PropertyExists.PROPERTY_EXISTS;
    }

    public Integer getId() {
        return id;
    }

    public CommentsItemTypePhoto setId(Integer id) {
        this.id = id;
        return this;
    }

    public List<Image> getImages() {
        return images;
    }

    public CommentsItemTypePhoto setImages(List<Image> images) {
        this.images = images;
        return this;
    }

    public Number getLat() {
        return lat;
    }

    public CommentsItemTypePhoto setLat(Number lat) {
        this.lat = lat;
        return this;
    }

    public Likes getLikes() {
        return likes;
    }

    public CommentsItemTypePhoto setLikes(Likes likes) {
        this.likes = likes;
        return this;
    }

    public Number getLng() {
        return lng;
    }

    public CommentsItemTypePhoto setLng(Number lng) {
        this.lng = lng;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public CommentsItemTypePhoto setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public URI getPhoto256() {
        return photo256;
    }

    public CommentsItemTypePhoto setPhoto256(URI photo256) {
        this.photo256 = photo256;
        return this;
    }

    public String getPlace() {
        return place;
    }

    public CommentsItemTypePhoto setPlace(String place) {
        this.place = place;
        return this;
    }

    public Integer getRealOffset() {
        return realOffset;
    }

    public CommentsItemTypePhoto setRealOffset(Integer realOffset) {
        this.realOffset = realOffset;
        return this;
    }

    public RepostsInfo getReposts() {
        return reposts;
    }

    public CommentsItemTypePhoto setReposts(RepostsInfo reposts) {
        this.reposts = reposts;
        return this;
    }

    public List<PhotoSizes> getSizes() {
        return sizes;
    }

    public CommentsItemTypePhoto setSizes(List<PhotoSizes> sizes) {
        this.sizes = sizes;
        return this;
    }

    public String getSquareCrop() {
        return squareCrop;
    }

    public CommentsItemTypePhoto setSquareCrop(String squareCrop) {
        this.squareCrop = squareCrop;
        return this;
    }

    public ObjectCount getTags() {
        return tags;
    }

    public CommentsItemTypePhoto setTags(ObjectCount tags) {
        this.tags = tags;
        return this;
    }

    public String getText() {
        return text;
    }

    public CommentsItemTypePhoto setText(String text) {
        this.text = text;
        return this;
    }

    public Long getUserId() {
        return userId;
    }

    public CommentsItemTypePhoto setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public CommentsItemTypePhotoVerticalAlign getVerticalAlign() {
        return verticalAlign;
    }

    public CommentsItemTypePhoto setVerticalAlign(
            CommentsItemTypePhotoVerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public CommentsItemTypePhoto setWidth(Integer width) {
        this.width = width;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(verticalAlign, images, comments, hidden, lng, albumId, photo256, ownerId, userId, tags, realOffset, sizes, accessKey, width, hasTags, canComment, id, place, text, squareCrop, lat, reposts, height, likes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommentsItemTypePhoto commentsItemTypePhoto = (CommentsItemTypePhoto) o;
        return Objects.equals(images, commentsItemTypePhoto.images) &&
                Objects.equals(comments, commentsItemTypePhoto.comments) &&
                Objects.equals(hidden, commentsItemTypePhoto.hidden) &&
                Objects.equals(verticalAlign, commentsItemTypePhoto.verticalAlign) &&
                Objects.equals(ownerId, commentsItemTypePhoto.ownerId) &&
                Objects.equals(lng, commentsItemTypePhoto.lng) &&
                Objects.equals(tags, commentsItemTypePhoto.tags) &&
                Objects.equals(realOffset, commentsItemTypePhoto.realOffset) &&
                Objects.equals(canComment, commentsItemTypePhoto.canComment) &&
                Objects.equals(sizes, commentsItemTypePhoto.sizes) &&
                Objects.equals(userId, commentsItemTypePhoto.userId) &&
                Objects.equals(accessKey, commentsItemTypePhoto.accessKey) &&
                Objects.equals(width, commentsItemTypePhoto.width) &&
                Objects.equals(albumId, commentsItemTypePhoto.albumId) &&
                Objects.equals(hasTags, commentsItemTypePhoto.hasTags) &&
                Objects.equals(id, commentsItemTypePhoto.id) &&
                Objects.equals(place, commentsItemTypePhoto.place) &&
                Objects.equals(squareCrop, commentsItemTypePhoto.squareCrop) &&
                Objects.equals(text, commentsItemTypePhoto.text) &&
                Objects.equals(lat, commentsItemTypePhoto.lat) &&
                Objects.equals(photo256, commentsItemTypePhoto.photo256) &&
                Objects.equals(reposts, commentsItemTypePhoto.reposts) &&
                Objects.equals(height, commentsItemTypePhoto.height) &&
                Objects.equals(likes, commentsItemTypePhoto.likes);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("CommentsItemTypePhoto{");
        sb.append("images=").append(images);
        sb.append(", comments=").append(comments);
        sb.append(", hidden=").append(hidden);
        sb.append(", verticalAlign='").append(verticalAlign).append("'");
        sb.append(", ownerId=").append(ownerId);
        sb.append(", lng=").append(lng);
        sb.append(", tags=").append(tags);
        sb.append(", realOffset=").append(realOffset);
        sb.append(", canComment=").append(canComment);
        sb.append(", sizes=").append(sizes);
        sb.append(", userId=").append(userId);
        sb.append(", accessKey='").append(accessKey).append("'");
        sb.append(", width=").append(width);
        sb.append(", albumId=").append(albumId);
        sb.append(", hasTags=").append(hasTags);
        sb.append(", id=").append(id);
        sb.append(", place='").append(place).append("'");
        sb.append(", squareCrop='").append(squareCrop).append("'");
        sb.append(", text='").append(text).append("'");
        sb.append(", lat=").append(lat);
        sb.append(", photo256=").append(photo256);
        sb.append(", reposts=").append(reposts);
        sb.append(", height=").append(height);
        sb.append(", likes=").append(likes);
        sb.append('}');
        return sb.toString();
    }
}
