// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.newsfeed;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.base.Likes;
import com.vk.api.sdk.objects.base.PropertyExists;
import com.vk.api.sdk.objects.base.RepostsInfo;
import com.vk.api.sdk.objects.video.VideoImage;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * CommentsItemTypeVideo object
 */
public class CommentsItemTypeVideo extends CommentsItemBase implements Validable {
    /**
     * Video access key
     */
    @SerializedName("access_key")
    private String accessKey;

    /**
     * 1 if video is added to user's albums
     */
    @SerializedName("added")
    private BoolInt added;

    /**
     * Date when the video has been added in Unixtime
     */
    @SerializedName("adding_date")
    private Integer addingDate;

    /**
     * Live donations balance
     */
    @SerializedName("balance")
    private Integer balance;

    /**
     * Information whether current user can add the video
     */
    @SerializedName("can_add")
    private BoolInt canAdd;

    /**
     * Information whether current user can add the video to favourites
     */
    @SerializedName("can_add_to_faves")
    private BoolInt canAddToFaves;

    /**
     * Information whether current user can attach action button to the video
     */
    @SerializedName("can_attach_link")
    private BoolInt canAttachLink;

    /**
     * Information whether current user can comment the video
     */
    @SerializedName("can_comment")
    private BoolInt canComment;

    /**
     * Information whether current user can delete the video
     */
    @SerializedName("can_delete")
    private BoolInt canDelete;

    /**
     * Information whether current user can edit the video
     */
    @SerializedName("can_edit")
    private BoolInt canEdit;

    /**
     * Information whether current user can edit the video privacy
     */
    @SerializedName("can_edit_privacy")
    private BoolInt canEditPrivacy;

    /**
     * Information whether current user can like the video
     */
    @SerializedName("can_like")
    private BoolInt canLike;

    /**
     * Information whether current user can repost the video
     */
    @SerializedName("can_repost")
    private Integer canRepost;

    /**
     * Information whether current user can subscribe to author of the video
     */
    @SerializedName("can_subscribe")
    private BoolInt canSubscribe;

    /**
     * Number of comments
     */
    @SerializedName("comments")
    private Integer comments;

    /**
     * Restriction code
     */
    @SerializedName("content_restricted")
    private Integer contentRestricted;

    /**
     * Restriction text
     */
    @SerializedName("content_restricted_message")
    private String contentRestrictedMessage;

    /**
     * 1 if  video is being converted
     */
    @SerializedName("converting")
    private BoolInt converting;

    /**
     * Video description
     */
    @SerializedName("description")
    private String description;

    /**
     * Video duration in seconds
     */
    @SerializedName("duration")
    private Integer duration;

    @SerializedName("first_frame")
    private List<VideoImage> firstFrame;

    /**
     * Video height
     */
    @SerializedName("height")
    private Integer height;

    /**
     * Video ID
     */
    @SerializedName("id")
    private Integer id;

    @SerializedName("image")
    private List<VideoImage> image;

    /**
     * Whether video is added to bookmarks
     */
    @SerializedName("is_favorite")
    private Boolean isFavorite;

    /**
     * 1 if video is private
     */
    @SerializedName("is_private")
    private BoolInt isPrivate;

    /**
     * 1 if user is subscribed to author of the video
     */
    @SerializedName("is_subscribed")
    private BoolInt isSubscribed;

    @SerializedName("likes")
    private Likes likes;

    /**
     * 1 if the video is a live stream
     */
    @SerializedName("live")
    private PropertyExists live;

    /**
     * Whether current user is subscribed to the upcoming live stream notification (if not subscribed to the author)
     */
    @SerializedName("live_notify")
    private BoolInt liveNotify;

    /**
     * Date in Unixtime when the live stream is scheduled to start by the author
     */
    @SerializedName("live_start_time")
    private Integer liveStartTime;

    /**
     * If video is external, number of views on vk
     */
    @SerializedName("local_views")
    private Integer localViews;

    /**
     * Video owner ID
     * Entity: owner
     */
    @SerializedName("owner_id")
    private Long ownerId;

    /**
     * External platform
     */
    @SerializedName("platform")
    private String platform;

    /**
     * Video embed URL
     */
    @SerializedName("player")
    private URI player;

    /**
     * Returns if the video is processing
     */
    @SerializedName("processing")
    private PropertyExists processing;

    /**
     * Information whether the video is repeated
     */
    @SerializedName("repeat")
    private PropertyExists repeat;

    @SerializedName("reposts")
    private RepostsInfo reposts;

    @SerializedName("response_type")
    private CommentsItemTypeVideoResponseType responseType;

    /**
     * Number of spectators of the stream
     */
    @SerializedName("spectators")
    private Integer spectators;

    @SerializedName("text")
    private String text;

    /**
     * Video title
     */
    @SerializedName("title")
    private String title;

    @SerializedName("track_code")
    private String trackCode;

    /**
     * 1 if the video is an upcoming stream
     */
    @SerializedName("upcoming")
    private PropertyExists upcoming;

    /**
     * Id of the user who uploaded the video if it was uploaded to a group by member
     * Entity: owner
     */
    @SerializedName("user_id")
    private Long userId;

    /**
     * Number of views
     */
    @SerializedName("views")
    private Integer views;

    /**
     * Video width
     */
    @SerializedName("width")
    private Integer width;

    public String getAccessKey() {
        return accessKey;
    }

    public CommentsItemTypeVideo setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public boolean isAdded() {
        return added == BoolInt.YES;
    }

    public BoolInt getAdded() {
        return added;
    }

    public Integer getAddingDate() {
        return addingDate;
    }

    public CommentsItemTypeVideo setAddingDate(Integer addingDate) {
        this.addingDate = addingDate;
        return this;
    }

    public Integer getBalance() {
        return balance;
    }

    public CommentsItemTypeVideo setBalance(Integer balance) {
        this.balance = balance;
        return this;
    }

    public boolean canAdd() {
        return canAdd == BoolInt.YES;
    }

    public BoolInt getCanAdd() {
        return canAdd;
    }

    public boolean canAddToFaves() {
        return canAddToFaves == BoolInt.YES;
    }

    public BoolInt getCanAddToFaves() {
        return canAddToFaves;
    }

    public boolean canAttachLink() {
        return canAttachLink == BoolInt.YES;
    }

    public BoolInt getCanAttachLink() {
        return canAttachLink;
    }

    public boolean canComment() {
        return canComment == BoolInt.YES;
    }

    public BoolInt getCanComment() {
        return canComment;
    }

    public boolean canDelete() {
        return canDelete == BoolInt.YES;
    }

    public BoolInt getCanDelete() {
        return canDelete;
    }

    public boolean canEdit() {
        return canEdit == BoolInt.YES;
    }

    public BoolInt getCanEdit() {
        return canEdit;
    }

    public boolean canEditPrivacy() {
        return canEditPrivacy == BoolInt.YES;
    }

    public BoolInt getCanEditPrivacy() {
        return canEditPrivacy;
    }

    public boolean canLike() {
        return canLike == BoolInt.YES;
    }

    public BoolInt getCanLike() {
        return canLike;
    }

    public Integer getCanRepost() {
        return canRepost;
    }

    public CommentsItemTypeVideo setCanRepost(Integer canRepost) {
        this.canRepost = canRepost;
        return this;
    }

    public boolean canSubscribe() {
        return canSubscribe == BoolInt.YES;
    }

    public BoolInt getCanSubscribe() {
        return canSubscribe;
    }

    public Integer getComments() {
        return comments;
    }

    public CommentsItemTypeVideo setComments(Integer comments) {
        this.comments = comments;
        return this;
    }

    public Integer getContentRestricted() {
        return contentRestricted;
    }

    public CommentsItemTypeVideo setContentRestricted(Integer contentRestricted) {
        this.contentRestricted = contentRestricted;
        return this;
    }

    public String getContentRestrictedMessage() {
        return contentRestrictedMessage;
    }

    public CommentsItemTypeVideo setContentRestrictedMessage(String contentRestrictedMessage) {
        this.contentRestrictedMessage = contentRestrictedMessage;
        return this;
    }

    public boolean isConverting() {
        return converting == BoolInt.YES;
    }

    public BoolInt getConverting() {
        return converting;
    }

    public String getDescription() {
        return description;
    }

    public CommentsItemTypeVideo setDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer getDuration() {
        return duration;
    }

    public CommentsItemTypeVideo setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public List<VideoImage> getFirstFrame() {
        return firstFrame;
    }

    public CommentsItemTypeVideo setFirstFrame(List<VideoImage> firstFrame) {
        this.firstFrame = firstFrame;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public CommentsItemTypeVideo setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Integer getId() {
        return id;
    }

    public CommentsItemTypeVideo setId(Integer id) {
        this.id = id;
        return this;
    }

    public List<VideoImage> getImage() {
        return image;
    }

    public CommentsItemTypeVideo setImage(List<VideoImage> image) {
        this.image = image;
        return this;
    }

    public Boolean getIsFavorite() {
        return isFavorite;
    }

    public CommentsItemTypeVideo setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    public boolean isPrivate() {
        return isPrivate == BoolInt.YES;
    }

    public BoolInt getIsPrivate() {
        return isPrivate;
    }

    public boolean isSubscribed() {
        return isSubscribed == BoolInt.YES;
    }

    public BoolInt getIsSubscribed() {
        return isSubscribed;
    }

    public Likes getLikes() {
        return likes;
    }

    public CommentsItemTypeVideo setLikes(Likes likes) {
        this.likes = likes;
        return this;
    }

    public boolean isLive() {
        return live == PropertyExists.PROPERTY_EXISTS;
    }

    public boolean isLiveNotify() {
        return liveNotify == BoolInt.YES;
    }

    public BoolInt getLiveNotify() {
        return liveNotify;
    }

    public Integer getLiveStartTime() {
        return liveStartTime;
    }

    public CommentsItemTypeVideo setLiveStartTime(Integer liveStartTime) {
        this.liveStartTime = liveStartTime;
        return this;
    }

    public Integer getLocalViews() {
        return localViews;
    }

    public CommentsItemTypeVideo setLocalViews(Integer localViews) {
        this.localViews = localViews;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public CommentsItemTypeVideo setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String getPlatform() {
        return platform;
    }

    public CommentsItemTypeVideo setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public URI getPlayer() {
        return player;
    }

    public CommentsItemTypeVideo setPlayer(URI player) {
        this.player = player;
        return this;
    }

    public boolean isProcessing() {
        return processing == PropertyExists.PROPERTY_EXISTS;
    }

    public boolean isRepeat() {
        return repeat == PropertyExists.PROPERTY_EXISTS;
    }

    public RepostsInfo getReposts() {
        return reposts;
    }

    public CommentsItemTypeVideo setReposts(RepostsInfo reposts) {
        this.reposts = reposts;
        return this;
    }

    public CommentsItemTypeVideoResponseType getResponseType() {
        return responseType;
    }

    public CommentsItemTypeVideo setResponseType(CommentsItemTypeVideoResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    public Integer getSpectators() {
        return spectators;
    }

    public CommentsItemTypeVideo setSpectators(Integer spectators) {
        this.spectators = spectators;
        return this;
    }

    public String getText() {
        return text;
    }

    public CommentsItemTypeVideo setText(String text) {
        this.text = text;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public CommentsItemTypeVideo setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTrackCode() {
        return trackCode;
    }

    public CommentsItemTypeVideo setTrackCode(String trackCode) {
        this.trackCode = trackCode;
        return this;
    }

    public boolean isUpcoming() {
        return upcoming == PropertyExists.PROPERTY_EXISTS;
    }

    public Long getUserId() {
        return userId;
    }

    public CommentsItemTypeVideo setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public Integer getViews() {
        return views;
    }

    public CommentsItemTypeVideo setViews(Integer views) {
        this.views = views;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public CommentsItemTypeVideo setWidth(Integer width) {
        this.width = width;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(added, converting, canLike, canEdit, canAdd, canAddToFaves, description, canEditPrivacy, isPrivate, ownerId, liveNotify, title, liveStartTime, platform, duration, canSubscribe, responseType, isSubscribed, balance, firstFrame, repeat, canDelete, canComment, id, text, addingDate, live, views, height, likes, player, trackCode, image, comments, contentRestrictedMessage, canRepost, contentRestricted, spectators, userId, localViews, canAttachLink, accessKey, width, processing, reposts, upcoming, isFavorite);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommentsItemTypeVideo commentsItemTypeVideo = (CommentsItemTypeVideo) o;
        return Objects.equals(isPrivate, commentsItemTypeVideo.isPrivate) &&
                Objects.equals(isFavorite, commentsItemTypeVideo.isFavorite) &&
                Objects.equals(addingDate, commentsItemTypeVideo.addingDate) &&
                Objects.equals(canAddToFaves, commentsItemTypeVideo.canAddToFaves) &&
                Objects.equals(added, commentsItemTypeVideo.added) &&
                Objects.equals(converting, commentsItemTypeVideo.converting) &&
                Objects.equals(ownerId, commentsItemTypeVideo.ownerId) &&
                Objects.equals(liveNotify, commentsItemTypeVideo.liveNotify) &&
                Objects.equals(contentRestrictedMessage, commentsItemTypeVideo.contentRestrictedMessage) &&
                Objects.equals(description, commentsItemTypeVideo.description) &&
                Objects.equals(responseType, commentsItemTypeVideo.responseType) &&
                Objects.equals(canAttachLink, commentsItemTypeVideo.canAttachLink) &&
                Objects.equals(title, commentsItemTypeVideo.title) &&
                Objects.equals(platform, commentsItemTypeVideo.platform) &&
                Objects.equals(duration, commentsItemTypeVideo.duration) &&
                Objects.equals(canComment, commentsItemTypeVideo.canComment) &&
                Objects.equals(localViews, commentsItemTypeVideo.localViews) &&
                Objects.equals(balance, commentsItemTypeVideo.balance) &&
                Objects.equals(canLike, commentsItemTypeVideo.canLike) &&
                Objects.equals(canDelete, commentsItemTypeVideo.canDelete) &&
                Objects.equals(repeat, commentsItemTypeVideo.repeat) &&
                Objects.equals(id, commentsItemTypeVideo.id) &&
                Objects.equals(text, commentsItemTypeVideo.text) &&
                Objects.equals(live, commentsItemTypeVideo.live) &&
                Objects.equals(views, commentsItemTypeVideo.views) &&
                Objects.equals(height, commentsItemTypeVideo.height) &&
                Objects.equals(likes, commentsItemTypeVideo.likes) &&
                Objects.equals(player, commentsItemTypeVideo.player) &&
                Objects.equals(liveStartTime, commentsItemTypeVideo.liveStartTime) &&
                Objects.equals(image, commentsItemTypeVideo.image) &&
                Objects.equals(comments, commentsItemTypeVideo.comments) &&
                Objects.equals(contentRestricted, commentsItemTypeVideo.contentRestricted) &&
                Objects.equals(canEdit, commentsItemTypeVideo.canEdit) &&
                Objects.equals(spectators, commentsItemTypeVideo.spectators) &&
                Objects.equals(canSubscribe, commentsItemTypeVideo.canSubscribe) &&
                Objects.equals(canRepost, commentsItemTypeVideo.canRepost) &&
                Objects.equals(canEditPrivacy, commentsItemTypeVideo.canEditPrivacy) &&
                Objects.equals(userId, commentsItemTypeVideo.userId) &&
                Objects.equals(accessKey, commentsItemTypeVideo.accessKey) &&
                Objects.equals(width, commentsItemTypeVideo.width) &&
                Objects.equals(processing, commentsItemTypeVideo.processing) &&
                Objects.equals(isSubscribed, commentsItemTypeVideo.isSubscribed) &&
                Objects.equals(trackCode, commentsItemTypeVideo.trackCode) &&
                Objects.equals(canAdd, commentsItemTypeVideo.canAdd) &&
                Objects.equals(reposts, commentsItemTypeVideo.reposts) &&
                Objects.equals(upcoming, commentsItemTypeVideo.upcoming) &&
                Objects.equals(firstFrame, commentsItemTypeVideo.firstFrame);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("CommentsItemTypeVideo{");
        sb.append("isPrivate=").append(isPrivate);
        sb.append(", isFavorite=").append(isFavorite);
        sb.append(", addingDate=").append(addingDate);
        sb.append(", canAddToFaves=").append(canAddToFaves);
        sb.append(", added=").append(added);
        sb.append(", converting=").append(converting);
        sb.append(", ownerId=").append(ownerId);
        sb.append(", liveNotify=").append(liveNotify);
        sb.append(", contentRestrictedMessage='").append(contentRestrictedMessage).append("'");
        sb.append(", description='").append(description).append("'");
        sb.append(", responseType='").append(responseType).append("'");
        sb.append(", canAttachLink=").append(canAttachLink);
        sb.append(", title='").append(title).append("'");
        sb.append(", platform='").append(platform).append("'");
        sb.append(", duration=").append(duration);
        sb.append(", canComment=").append(canComment);
        sb.append(", localViews=").append(localViews);
        sb.append(", balance=").append(balance);
        sb.append(", canLike=").append(canLike);
        sb.append(", canDelete=").append(canDelete);
        sb.append(", repeat=").append(repeat);
        sb.append(", id=").append(id);
        sb.append(", text='").append(text).append("'");
        sb.append(", live=").append(live);
        sb.append(", views=").append(views);
        sb.append(", height=").append(height);
        sb.append(", likes=").append(likes);
        sb.append(", player=").append(player);
        sb.append(", liveStartTime=").append(liveStartTime);
        sb.append(", image=").append(image);
        sb.append(", comments=").append(comments);
        sb.append(", contentRestricted=").append(contentRestricted);
        sb.append(", canEdit=").append(canEdit);
        sb.append(", spectators=").append(spectators);
        sb.append(", canSubscribe=").append(canSubscribe);
        sb.append(", canRepost=").append(canRepost);
        sb.append(", canEditPrivacy=").append(canEditPrivacy);
        sb.append(", userId=").append(userId);
        sb.append(", accessKey='").append(accessKey).append("'");
        sb.append(", width=").append(width);
        sb.append(", processing=").append(processing);
        sb.append(", isSubscribed=").append(isSubscribed);
        sb.append(", trackCode='").append(trackCode).append("'");
        sb.append(", canAdd=").append(canAdd);
        sb.append(", reposts=").append(reposts);
        sb.append(", upcoming=").append(upcoming);
        sb.append(", firstFrame=").append(firstFrame);
        sb.append('}');
        return sb.toString();
    }
}
