// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.newsfeed.responses;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.groups.GroupFull;
import com.vk.api.sdk.objects.newsfeed.NewsfeedItem;
import com.vk.api.sdk.objects.users.UserFull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * GenericResponse object
 */
public class GenericResponse implements Validable {
    @SerializedName("groups")
    @Required
    private List<GroupFull> groups;

    @SerializedName("items")
    @Required
    private List<JsonObject> items;

    @SerializedName("lives_items")
    private List<JsonObject> livesItems;

    @SerializedName("profiles")
    @Required
    private List<UserFull> profiles;

    public List<GroupFull> getGroups() {
        return groups;
    }

    public GenericResponse setGroups(List<GroupFull> groups) {
        this.groups = groups;
        return this;
    }

    public List<NewsfeedItem> getItems() {
        return items.stream().map(NewsfeedItem::new).collect(Collectors.toList());
    }

    public List<NewsfeedItem> getLivesItems() {
        return livesItems.stream().map(NewsfeedItem::new).collect(Collectors.toList());
    }

    public List<UserFull> getProfiles() {
        return profiles;
    }

    public GenericResponse setProfiles(List<UserFull> profiles) {
        this.profiles = profiles;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(profiles, groups, livesItems, items);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenericResponse genericResponse = (GenericResponse) o;
        return Objects.equals(profiles, genericResponse.profiles) &&
                Objects.equals(groups, genericResponse.groups) &&
                Objects.equals(livesItems, genericResponse.livesItems) &&
                Objects.equals(items, genericResponse.items);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("GenericResponse{");
        sb.append("profiles=").append(profiles);
        sb.append(", groups=").append(groups);
        sb.append(", livesItems=").append(livesItems);
        sb.append(", items=").append(items);
        sb.append('}');
        return sb.toString();
    }
}
