// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.notes;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.base.BoolInt;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * Note object
 */
public class Note implements Validable {
    /**
     * Information whether current user can comment the note
     */
    @SerializedName("can_comment")
    private BoolInt canComment;

    /**
     * Comments number
     */
    @SerializedName("comments")
    @Required
    private Integer comments;

    /**
     * Date when the note has been created in Unixtime
     */
    @SerializedName("date")
    @Required
    private Integer date;

    /**
     * Note ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    /**
     * Note owner's ID
     * Entity: owner
     */
    @SerializedName("owner_id")
    @Required
    private Long ownerId;

    @SerializedName("privacy_comment")
    private List<String> privacyComment;

    @SerializedName("privacy_view")
    private List<String> privacyView;

    @SerializedName("read_comments")
    private Integer readComments;

    /**
     * Note text
     */
    @SerializedName("text")
    private String text;

    /**
     * Note text in wiki format
     */
    @SerializedName("text_wiki")
    private String textWiki;

    /**
     * Note title
     */
    @SerializedName("title")
    @Required
    private String title;

    /**
     * URL of the page with note preview
     */
    @SerializedName("view_url")
    @Required
    private URI viewUrl;

    public boolean canComment() {
        return canComment == BoolInt.YES;
    }

    public BoolInt getCanComment() {
        return canComment;
    }

    public Integer getComments() {
        return comments;
    }

    public Note setComments(Integer comments) {
        this.comments = comments;
        return this;
    }

    public Integer getDate() {
        return date;
    }

    public Note setDate(Integer date) {
        this.date = date;
        return this;
    }

    public Integer getId() {
        return id;
    }

    public Note setId(Integer id) {
        this.id = id;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public Note setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public List<String> getPrivacyComment() {
        return privacyComment;
    }

    public Note setPrivacyComment(List<String> privacyComment) {
        this.privacyComment = privacyComment;
        return this;
    }

    public List<String> getPrivacyView() {
        return privacyView;
    }

    public Note setPrivacyView(List<String> privacyView) {
        this.privacyView = privacyView;
        return this;
    }

    public Integer getReadComments() {
        return readComments;
    }

    public Note setReadComments(Integer readComments) {
        this.readComments = readComments;
        return this;
    }

    public String getText() {
        return text;
    }

    public Note setText(String text) {
        this.text = text;
        return this;
    }

    public String getTextWiki() {
        return textWiki;
    }

    public Note setTextWiki(String textWiki) {
        this.textWiki = textWiki;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public Note setTitle(String title) {
        this.title = title;
        return this;
    }

    public URI getViewUrl() {
        return viewUrl;
    }

    public Note setViewUrl(URI viewUrl) {
        this.viewUrl = viewUrl;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, privacyView, textWiki, comments, privacyComment, viewUrl, canComment, id, text, ownerId, title, readComments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Note note = (Note) o;
        return Objects.equals(date, note.date) &&
                Objects.equals(canComment, note.canComment) &&
                Objects.equals(comments, note.comments) &&
                Objects.equals(ownerId, note.ownerId) &&
                Objects.equals(privacyComment, note.privacyComment) &&
                Objects.equals(readComments, note.readComments) &&
                Objects.equals(viewUrl, note.viewUrl) &&
                Objects.equals(id, note.id) &&
                Objects.equals(text, note.text) &&
                Objects.equals(textWiki, note.textWiki) &&
                Objects.equals(title, note.title) &&
                Objects.equals(privacyView, note.privacyView);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("Note{");
        sb.append("date=").append(date);
        sb.append(", canComment=").append(canComment);
        sb.append(", comments=").append(comments);
        sb.append(", ownerId=").append(ownerId);
        sb.append(", privacyComment='").append(privacyComment).append("'");
        sb.append(", readComments=").append(readComments);
        sb.append(", viewUrl=").append(viewUrl);
        sb.append(", id=").append(id);
        sb.append(", text='").append(text).append("'");
        sb.append(", textWiki='").append(textWiki).append("'");
        sb.append(", title='").append(title).append("'");
        sb.append(", privacyView='").append(privacyView).append("'");
        sb.append('}');
        return sb.toString();
    }
}
