// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.orders;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import java.util.Objects;

/**
 * Subscription object
 */
public class Subscription implements Validable {
    /**
     * Subscription's application id
     */
    @SerializedName("app_id")
    private Integer appId;

    /**
     * Subscription's application name
     */
    @SerializedName("application_name")
    private String applicationName;

    /**
     * Cancel reason
     */
    @SerializedName("cancel_reason")
    private String cancelReason;

    /**
     * Date of creation in Unixtime
     */
    @SerializedName("create_time")
    @Required
    private Integer createTime;

    /**
     * Subscription expiration time in Unixtime
     */
    @SerializedName("expire_time")
    private Integer expireTime;

    /**
     * Subscription ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    /**
     * Is game (not miniapp) subscription
     */
    @SerializedName("is_game")
    private Boolean isGame;

    /**
     * Subscription order item
     */
    @SerializedName("item_id")
    @Required
    private String itemId;

    /**
     * Date of next bill in Unixtime
     */
    @SerializedName("next_bill_time")
    private Integer nextBillTime;

    /**
     * Pending cancel state
     */
    @SerializedName("pending_cancel")
    private Boolean pendingCancel;

    /**
     * Subscription period
     */
    @SerializedName("period")
    @Required
    private Integer period;

    /**
     * Date of last period start in Unixtime
     */
    @SerializedName("period_start_time")
    @Required
    private Integer periodStartTime;

    /**
     * Item photo image url
     */
    @SerializedName("photo_url")
    private String photoUrl;

    /**
     * Subscription price
     */
    @SerializedName("price")
    @Required
    private Integer price;

    /**
     * Subscription status
     */
    @SerializedName("status")
    @Required
    private String status;

    /**
     * Is test subscription
     */
    @SerializedName("test_mode")
    private Boolean testMode;

    /**
     * Subscription name
     */
    @SerializedName("title")
    private String title;

    /**
     * Date of trial expire in Unixtime
     */
    @SerializedName("trial_expire_time")
    private Integer trialExpireTime;

    /**
     * Date of last change in Unixtime
     */
    @SerializedName("update_time")
    @Required
    private Integer updateTime;

    public Integer getAppId() {
        return appId;
    }

    public Subscription setAppId(Integer appId) {
        this.appId = appId;
        return this;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public Subscription setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getCancelReason() {
        return cancelReason;
    }

    public Subscription setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    public Integer getCreateTime() {
        return createTime;
    }

    public Subscription setCreateTime(Integer createTime) {
        this.createTime = createTime;
        return this;
    }

    public Integer getExpireTime() {
        return expireTime;
    }

    public Subscription setExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    public Integer getId() {
        return id;
    }

    public Subscription setId(Integer id) {
        this.id = id;
        return this;
    }

    public Boolean getIsGame() {
        return isGame;
    }

    public Subscription setIsGame(Boolean isGame) {
        this.isGame = isGame;
        return this;
    }

    public String getItemId() {
        return itemId;
    }

    public Subscription setItemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    public Integer getNextBillTime() {
        return nextBillTime;
    }

    public Subscription setNextBillTime(Integer nextBillTime) {
        this.nextBillTime = nextBillTime;
        return this;
    }

    public Boolean getPendingCancel() {
        return pendingCancel;
    }

    public Subscription setPendingCancel(Boolean pendingCancel) {
        this.pendingCancel = pendingCancel;
        return this;
    }

    public Integer getPeriod() {
        return period;
    }

    public Subscription setPeriod(Integer period) {
        this.period = period;
        return this;
    }

    public Integer getPeriodStartTime() {
        return periodStartTime;
    }

    public Subscription setPeriodStartTime(Integer periodStartTime) {
        this.periodStartTime = periodStartTime;
        return this;
    }

    public String getPhotoUrl() {
        return photoUrl;
    }

    public Subscription setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
        return this;
    }

    public Integer getPrice() {
        return price;
    }

    public Subscription setPrice(Integer price) {
        this.price = price;
        return this;
    }

    public String getStatus() {
        return status;
    }

    public Subscription setStatus(String status) {
        this.status = status;
        return this;
    }

    public Boolean getTestMode() {
        return testMode;
    }

    public Subscription setTestMode(Boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public Subscription setTitle(String title) {
        this.title = title;
        return this;
    }

    public Integer getTrialExpireTime() {
        return trialExpireTime;
    }

    public Subscription setTrialExpireTime(Integer trialExpireTime) {
        this.trialExpireTime = trialExpireTime;
        return this;
    }

    public Integer getUpdateTime() {
        return updateTime;
    }

    public Subscription setUpdateTime(Integer updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(pendingCancel, period, updateTime, trialExpireTime, title, itemId, photoUrl, expireTime, createTime, price, testMode, appId, nextBillTime, periodStartTime, id, cancelReason, applicationName, isGame, status);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Subscription subscription = (Subscription) o;
        return Objects.equals(period, subscription.period) &&
                Objects.equals(createTime, subscription.createTime) &&
                Objects.equals(itemId, subscription.itemId) &&
                Objects.equals(nextBillTime, subscription.nextBillTime) &&
                Objects.equals(trialExpireTime, subscription.trialExpireTime) &&
                Objects.equals(expireTime, subscription.expireTime) &&
                Objects.equals(pendingCancel, subscription.pendingCancel) &&
                Objects.equals(title, subscription.title) &&
                Objects.equals(isGame, subscription.isGame) &&
                Objects.equals(periodStartTime, subscription.periodStartTime) &&
                Objects.equals(cancelReason, subscription.cancelReason) &&
                Objects.equals(updateTime, subscription.updateTime) &&
                Objects.equals(applicationName, subscription.applicationName) &&
                Objects.equals(testMode, subscription.testMode) &&
                Objects.equals(price, subscription.price) &&
                Objects.equals(id, subscription.id) &&
                Objects.equals(photoUrl, subscription.photoUrl) &&
                Objects.equals(appId, subscription.appId) &&
                Objects.equals(status, subscription.status);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("Subscription{");
        sb.append("period=").append(period);
        sb.append(", createTime=").append(createTime);
        sb.append(", itemId='").append(itemId).append("'");
        sb.append(", nextBillTime=").append(nextBillTime);
        sb.append(", trialExpireTime=").append(trialExpireTime);
        sb.append(", expireTime=").append(expireTime);
        sb.append(", pendingCancel=").append(pendingCancel);
        sb.append(", title='").append(title).append("'");
        sb.append(", isGame=").append(isGame);
        sb.append(", periodStartTime=").append(periodStartTime);
        sb.append(", cancelReason='").append(cancelReason).append("'");
        sb.append(", updateTime=").append(updateTime);
        sb.append(", applicationName='").append(applicationName).append("'");
        sb.append(", testMode=").append(testMode);
        sb.append(", price=").append(price);
        sb.append(", id=").append(id);
        sb.append(", photoUrl='").append(photoUrl).append("'");
        sb.append(", appId=").append(appId);
        sb.append(", status='").append(status).append("'");
        sb.append('}');
        return sb.toString();
    }
}
