// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.photos.responses;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.base.Likes;
import com.vk.api.sdk.objects.base.ObjectCount;
import com.vk.api.sdk.objects.base.PropertyExists;
import com.vk.api.sdk.objects.base.RepostsInfo;
import com.vk.api.sdk.objects.photos.Image;
import com.vk.api.sdk.objects.photos.PhotoSizes;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * SaveResponse object
 */
public class SaveResponse implements Validable {
    /**
     * Access key for the photo
     */
    @SerializedName("access_key")
    private String accessKey;

    /**
     * Album ID
     */
    @SerializedName("album_id")
    @Required
    private Integer albumId;

    /**
     * Information whether current user can comment the photo
     */
    @SerializedName("can_comment")
    private BoolInt canComment;

    @SerializedName("comments")
    private ObjectCount comments;

    /**
     * Date when uploaded
     */
    @SerializedName("date")
    @Required
    private Integer date;

    /**
     * Whether photo has attached tag links
     */
    @SerializedName("has_tags")
    @Required
    private Boolean hasTags;

    /**
     * Original photo height
     */
    @SerializedName("height")
    private Integer height;

    /**
     * Returns if the photo is hidden above the wall
     */
    @SerializedName("hidden")
    private PropertyExists hidden;

    /**
     * Photo ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    @SerializedName("images")
    private List<Image> images;

    /**
     * Latitude
     */
    @SerializedName("lat")
    private Number lat;

    @SerializedName("likes")
    private Likes likes;

    /**
     * Longitude
     */
    @SerializedName("long")
    private Number lng;

    /**
     * Photo owner's ID
     * Entity: owner
     */
    @SerializedName("owner_id")
    @Required
    private Long ownerId;

    /**
     * URL of image with 2560 px width
     */
    @SerializedName("photo_256")
    private URI photo256;

    @SerializedName("place")
    private String place;

    /**
     * Post ID
     */
    @SerializedName("post_id")
    private Integer postId;

    /**
     * Real position of the photo
     */
    @SerializedName("real_offset")
    private Integer realOffset;

    @SerializedName("reposts")
    private RepostsInfo reposts;

    @SerializedName("sizes")
    private List<PhotoSizes> sizes;

    @SerializedName("square_crop")
    private String squareCrop;

    @SerializedName("tags")
    private ObjectCount tags;

    /**
     * Photo caption
     */
    @SerializedName("text")
    private String text;

    /**
     * ID of the user who have uploaded the photo
     * Entity: owner
     */
    @SerializedName("user_id")
    private Long userId;

    /**
     * Sets vertical alignment of a photo
     */
    @SerializedName("vertical_align")
    private SaveResponseVerticalAlign verticalAlign;

    /**
     * Original photo width
     */
    @SerializedName("width")
    private Integer width;

    public String getAccessKey() {
        return accessKey;
    }

    public SaveResponse setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public Integer getAlbumId() {
        return albumId;
    }

    public SaveResponse setAlbumId(Integer albumId) {
        this.albumId = albumId;
        return this;
    }

    public boolean canComment() {
        return canComment == BoolInt.YES;
    }

    public BoolInt getCanComment() {
        return canComment;
    }

    public ObjectCount getComments() {
        return comments;
    }

    public SaveResponse setComments(ObjectCount comments) {
        this.comments = comments;
        return this;
    }

    public Integer getDate() {
        return date;
    }

    public SaveResponse setDate(Integer date) {
        this.date = date;
        return this;
    }

    public Boolean getHasTags() {
        return hasTags;
    }

    public SaveResponse setHasTags(Boolean hasTags) {
        this.hasTags = hasTags;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public SaveResponse setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public boolean isHidden() {
        return hidden == PropertyExists.PROPERTY_EXISTS;
    }

    public Integer getId() {
        return id;
    }

    public SaveResponse setId(Integer id) {
        this.id = id;
        return this;
    }

    public List<Image> getImages() {
        return images;
    }

    public SaveResponse setImages(List<Image> images) {
        this.images = images;
        return this;
    }

    public Number getLat() {
        return lat;
    }

    public SaveResponse setLat(Number lat) {
        this.lat = lat;
        return this;
    }

    public Likes getLikes() {
        return likes;
    }

    public SaveResponse setLikes(Likes likes) {
        this.likes = likes;
        return this;
    }

    public Number getLng() {
        return lng;
    }

    public SaveResponse setLng(Number lng) {
        this.lng = lng;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public SaveResponse setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public URI getPhoto256() {
        return photo256;
    }

    public SaveResponse setPhoto256(URI photo256) {
        this.photo256 = photo256;
        return this;
    }

    public String getPlace() {
        return place;
    }

    public SaveResponse setPlace(String place) {
        this.place = place;
        return this;
    }

    public Integer getPostId() {
        return postId;
    }

    public SaveResponse setPostId(Integer postId) {
        this.postId = postId;
        return this;
    }

    public Integer getRealOffset() {
        return realOffset;
    }

    public SaveResponse setRealOffset(Integer realOffset) {
        this.realOffset = realOffset;
        return this;
    }

    public RepostsInfo getReposts() {
        return reposts;
    }

    public SaveResponse setReposts(RepostsInfo reposts) {
        this.reposts = reposts;
        return this;
    }

    public List<PhotoSizes> getSizes() {
        return sizes;
    }

    public SaveResponse setSizes(List<PhotoSizes> sizes) {
        this.sizes = sizes;
        return this;
    }

    public String getSquareCrop() {
        return squareCrop;
    }

    public SaveResponse setSquareCrop(String squareCrop) {
        this.squareCrop = squareCrop;
        return this;
    }

    public ObjectCount getTags() {
        return tags;
    }

    public SaveResponse setTags(ObjectCount tags) {
        this.tags = tags;
        return this;
    }

    public String getText() {
        return text;
    }

    public SaveResponse setText(String text) {
        this.text = text;
        return this;
    }

    public Long getUserId() {
        return userId;
    }

    public SaveResponse setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public SaveResponseVerticalAlign getVerticalAlign() {
        return verticalAlign;
    }

    public SaveResponse setVerticalAlign(SaveResponseVerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public SaveResponse setWidth(Integer width) {
        this.width = width;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, hidden, albumId, ownerId, realOffset, sizes, hasTags, canComment, id, place, text, squareCrop, lat, height, likes, verticalAlign, images, comments, lng, photo256, postId, userId, tags, accessKey, width, reposts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SaveResponse saveResponse = (SaveResponse) o;
        return Objects.equals(date, saveResponse.date) &&
                Objects.equals(hidden, saveResponse.hidden) &&
                Objects.equals(ownerId, saveResponse.ownerId) &&
                Objects.equals(lng, saveResponse.lng) &&
                Objects.equals(canComment, saveResponse.canComment) &&
                Objects.equals(sizes, saveResponse.sizes) &&
                Objects.equals(id, saveResponse.id) &&
                Objects.equals(place, saveResponse.place) &&
                Objects.equals(text, saveResponse.text) &&
                Objects.equals(lat, saveResponse.lat) &&
                Objects.equals(height, saveResponse.height) &&
                Objects.equals(likes, saveResponse.likes) &&
                Objects.equals(images, saveResponse.images) &&
                Objects.equals(comments, saveResponse.comments) &&
                Objects.equals(verticalAlign, saveResponse.verticalAlign) &&
                Objects.equals(tags, saveResponse.tags) &&
                Objects.equals(realOffset, saveResponse.realOffset) &&
                Objects.equals(postId, saveResponse.postId) &&
                Objects.equals(userId, saveResponse.userId) &&
                Objects.equals(accessKey, saveResponse.accessKey) &&
                Objects.equals(width, saveResponse.width) &&
                Objects.equals(albumId, saveResponse.albumId) &&
                Objects.equals(hasTags, saveResponse.hasTags) &&
                Objects.equals(squareCrop, saveResponse.squareCrop) &&
                Objects.equals(photo256, saveResponse.photo256) &&
                Objects.equals(reposts, saveResponse.reposts);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("SaveResponse{");
        sb.append("date=").append(date);
        sb.append(", hidden=").append(hidden);
        sb.append(", ownerId=").append(ownerId);
        sb.append(", lng=").append(lng);
        sb.append(", canComment=").append(canComment);
        sb.append(", sizes=").append(sizes);
        sb.append(", id=").append(id);
        sb.append(", place='").append(place).append("'");
        sb.append(", text='").append(text).append("'");
        sb.append(", lat=").append(lat);
        sb.append(", height=").append(height);
        sb.append(", likes=").append(likes);
        sb.append(", images=").append(images);
        sb.append(", comments=").append(comments);
        sb.append(", verticalAlign='").append(verticalAlign).append("'");
        sb.append(", tags=").append(tags);
        sb.append(", realOffset=").append(realOffset);
        sb.append(", postId=").append(postId);
        sb.append(", userId=").append(userId);
        sb.append(", accessKey='").append(accessKey).append("'");
        sb.append(", width=").append(width);
        sb.append(", albumId=").append(albumId);
        sb.append(", hasTags=").append(hasTags);
        sb.append(", squareCrop='").append(squareCrop).append("'");
        sb.append(", photo256=").append(photo256);
        sb.append(", reposts=").append(reposts);
        sb.append('}');
        return sb.toString();
    }
}
