// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.photos.responses;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.base.Likes;
import com.vk.api.sdk.objects.base.ObjectCount;
import com.vk.api.sdk.objects.base.PropertyExists;
import com.vk.api.sdk.objects.base.RepostsInfo;
import com.vk.api.sdk.objects.photos.Image;
import com.vk.api.sdk.objects.photos.PhotoSizes;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * SaveWallPhotoResponse object
 */
public class SaveWallPhotoResponse implements Validable {
    /**
     * Access key for the photo
     */
    @SerializedName("access_key")
    private String accessKey;

    /**
     * Album ID
     */
    @SerializedName("album_id")
    @Required
    private Integer albumId;

    /**
     * Information whether current user can comment the photo
     */
    @SerializedName("can_comment")
    private BoolInt canComment;

    @SerializedName("comments")
    private ObjectCount comments;

    /**
     * Date when uploaded
     */
    @SerializedName("date")
    @Required
    private Integer date;

    /**
     * Whether photo has attached tag links
     */
    @SerializedName("has_tags")
    @Required
    private Boolean hasTags;

    /**
     * Original photo height
     */
    @SerializedName("height")
    private Integer height;

    /**
     * Returns if the photo is hidden above the wall
     */
    @SerializedName("hidden")
    private PropertyExists hidden;

    /**
     * Photo ID
     */
    @SerializedName("id")
    @Required
    private Integer id;

    @SerializedName("images")
    private List<Image> images;

    /**
     * Latitude
     */
    @SerializedName("lat")
    private Number lat;

    @SerializedName("likes")
    private Likes likes;

    /**
     * Longitude
     */
    @SerializedName("long")
    private Number lng;

    /**
     * Photo owner's ID
     * Entity: owner
     */
    @SerializedName("owner_id")
    @Required
    private Long ownerId;

    /**
     * URL of image with 2560 px width
     */
    @SerializedName("photo_256")
    private URI photo256;

    @SerializedName("place")
    private String place;

    /**
     * Post ID
     */
    @SerializedName("post_id")
    private Integer postId;

    /**
     * Real position of the photo
     */
    @SerializedName("real_offset")
    private Integer realOffset;

    @SerializedName("reposts")
    private RepostsInfo reposts;

    @SerializedName("sizes")
    private List<PhotoSizes> sizes;

    @SerializedName("square_crop")
    private String squareCrop;

    @SerializedName("tags")
    private ObjectCount tags;

    /**
     * Photo caption
     */
    @SerializedName("text")
    private String text;

    /**
     * ID of the user who have uploaded the photo
     * Entity: owner
     */
    @SerializedName("user_id")
    private Long userId;

    /**
     * Sets vertical alignment of a photo
     */
    @SerializedName("vertical_align")
    private SaveWallPhotoResponseVerticalAlign verticalAlign;

    /**
     * Original photo width
     */
    @SerializedName("width")
    private Integer width;

    public String getAccessKey() {
        return accessKey;
    }

    public SaveWallPhotoResponse setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public Integer getAlbumId() {
        return albumId;
    }

    public SaveWallPhotoResponse setAlbumId(Integer albumId) {
        this.albumId = albumId;
        return this;
    }

    public boolean canComment() {
        return canComment == BoolInt.YES;
    }

    public BoolInt getCanComment() {
        return canComment;
    }

    public ObjectCount getComments() {
        return comments;
    }

    public SaveWallPhotoResponse setComments(ObjectCount comments) {
        this.comments = comments;
        return this;
    }

    public Integer getDate() {
        return date;
    }

    public SaveWallPhotoResponse setDate(Integer date) {
        this.date = date;
        return this;
    }

    public Boolean getHasTags() {
        return hasTags;
    }

    public SaveWallPhotoResponse setHasTags(Boolean hasTags) {
        this.hasTags = hasTags;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public SaveWallPhotoResponse setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public boolean isHidden() {
        return hidden == PropertyExists.PROPERTY_EXISTS;
    }

    public Integer getId() {
        return id;
    }

    public SaveWallPhotoResponse setId(Integer id) {
        this.id = id;
        return this;
    }

    public List<Image> getImages() {
        return images;
    }

    public SaveWallPhotoResponse setImages(List<Image> images) {
        this.images = images;
        return this;
    }

    public Number getLat() {
        return lat;
    }

    public SaveWallPhotoResponse setLat(Number lat) {
        this.lat = lat;
        return this;
    }

    public Likes getLikes() {
        return likes;
    }

    public SaveWallPhotoResponse setLikes(Likes likes) {
        this.likes = likes;
        return this;
    }

    public Number getLng() {
        return lng;
    }

    public SaveWallPhotoResponse setLng(Number lng) {
        this.lng = lng;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public SaveWallPhotoResponse setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public URI getPhoto256() {
        return photo256;
    }

    public SaveWallPhotoResponse setPhoto256(URI photo256) {
        this.photo256 = photo256;
        return this;
    }

    public String getPlace() {
        return place;
    }

    public SaveWallPhotoResponse setPlace(String place) {
        this.place = place;
        return this;
    }

    public Integer getPostId() {
        return postId;
    }

    public SaveWallPhotoResponse setPostId(Integer postId) {
        this.postId = postId;
        return this;
    }

    public Integer getRealOffset() {
        return realOffset;
    }

    public SaveWallPhotoResponse setRealOffset(Integer realOffset) {
        this.realOffset = realOffset;
        return this;
    }

    public RepostsInfo getReposts() {
        return reposts;
    }

    public SaveWallPhotoResponse setReposts(RepostsInfo reposts) {
        this.reposts = reposts;
        return this;
    }

    public List<PhotoSizes> getSizes() {
        return sizes;
    }

    public SaveWallPhotoResponse setSizes(List<PhotoSizes> sizes) {
        this.sizes = sizes;
        return this;
    }

    public String getSquareCrop() {
        return squareCrop;
    }

    public SaveWallPhotoResponse setSquareCrop(String squareCrop) {
        this.squareCrop = squareCrop;
        return this;
    }

    public ObjectCount getTags() {
        return tags;
    }

    public SaveWallPhotoResponse setTags(ObjectCount tags) {
        this.tags = tags;
        return this;
    }

    public String getText() {
        return text;
    }

    public SaveWallPhotoResponse setText(String text) {
        this.text = text;
        return this;
    }

    public Long getUserId() {
        return userId;
    }

    public SaveWallPhotoResponse setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public SaveWallPhotoResponseVerticalAlign getVerticalAlign() {
        return verticalAlign;
    }

    public SaveWallPhotoResponse setVerticalAlign(
            SaveWallPhotoResponseVerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public SaveWallPhotoResponse setWidth(Integer width) {
        this.width = width;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, hidden, albumId, ownerId, realOffset, sizes, hasTags, canComment, id, place, text, squareCrop, lat, height, likes, verticalAlign, images, comments, lng, photo256, postId, userId, tags, accessKey, width, reposts);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SaveWallPhotoResponse saveWallPhotoResponse = (SaveWallPhotoResponse) o;
        return Objects.equals(date, saveWallPhotoResponse.date) &&
                Objects.equals(hidden, saveWallPhotoResponse.hidden) &&
                Objects.equals(ownerId, saveWallPhotoResponse.ownerId) &&
                Objects.equals(lng, saveWallPhotoResponse.lng) &&
                Objects.equals(canComment, saveWallPhotoResponse.canComment) &&
                Objects.equals(sizes, saveWallPhotoResponse.sizes) &&
                Objects.equals(id, saveWallPhotoResponse.id) &&
                Objects.equals(place, saveWallPhotoResponse.place) &&
                Objects.equals(text, saveWallPhotoResponse.text) &&
                Objects.equals(lat, saveWallPhotoResponse.lat) &&
                Objects.equals(height, saveWallPhotoResponse.height) &&
                Objects.equals(likes, saveWallPhotoResponse.likes) &&
                Objects.equals(images, saveWallPhotoResponse.images) &&
                Objects.equals(comments, saveWallPhotoResponse.comments) &&
                Objects.equals(verticalAlign, saveWallPhotoResponse.verticalAlign) &&
                Objects.equals(tags, saveWallPhotoResponse.tags) &&
                Objects.equals(realOffset, saveWallPhotoResponse.realOffset) &&
                Objects.equals(postId, saveWallPhotoResponse.postId) &&
                Objects.equals(userId, saveWallPhotoResponse.userId) &&
                Objects.equals(accessKey, saveWallPhotoResponse.accessKey) &&
                Objects.equals(width, saveWallPhotoResponse.width) &&
                Objects.equals(albumId, saveWallPhotoResponse.albumId) &&
                Objects.equals(hasTags, saveWallPhotoResponse.hasTags) &&
                Objects.equals(squareCrop, saveWallPhotoResponse.squareCrop) &&
                Objects.equals(photo256, saveWallPhotoResponse.photo256) &&
                Objects.equals(reposts, saveWallPhotoResponse.reposts);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("SaveWallPhotoResponse{");
        sb.append("date=").append(date);
        sb.append(", hidden=").append(hidden);
        sb.append(", ownerId=").append(ownerId);
        sb.append(", lng=").append(lng);
        sb.append(", canComment=").append(canComment);
        sb.append(", sizes=").append(sizes);
        sb.append(", id=").append(id);
        sb.append(", place='").append(place).append("'");
        sb.append(", text='").append(text).append("'");
        sb.append(", lat=").append(lat);
        sb.append(", height=").append(height);
        sb.append(", likes=").append(likes);
        sb.append(", images=").append(images);
        sb.append(", comments=").append(comments);
        sb.append(", verticalAlign='").append(verticalAlign).append("'");
        sb.append(", tags=").append(tags);
        sb.append(", realOffset=").append(realOffset);
        sb.append(", postId=").append(postId);
        sb.append(", userId=").append(userId);
        sb.append(", accessKey='").append(accessKey).append("'");
        sb.append(", width=").append(width);
        sb.append(", albumId=").append(albumId);
        sb.append(", hasTags=").append(hasTags);
        sb.append(", squareCrop='").append(squareCrop).append("'");
        sb.append(", photo256=").append(photo256);
        sb.append(", reposts=").append(reposts);
        sb.append('}');
        return sb.toString();
    }
}
