// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.store;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.base.Image;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * ProductIcon object
 */
public class ProductIcon implements Validable {
    /**
     * Base URL for images in set
     */
    @SerializedName("base_url")
    @Required
    private URI baseUrl;

    @SerializedName("images")
    private List<Image> images;

    /**
     * Version number to be appended to the image URL
     */
    @SerializedName("version")
    private Integer version;

    public URI getBaseUrl() {
        return baseUrl;
    }

    public ProductIcon setBaseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public List<Image> getImages() {
        return images;
    }

    public ProductIcon setImages(List<Image> images) {
        this.images = images;
        return this;
    }

    public Integer getVersion() {
        return version;
    }

    public ProductIcon setVersion(Integer version) {
        this.version = version;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(images, baseUrl, version);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProductIcon productIcon = (ProductIcon) o;
        return Objects.equals(images, productIcon.images) &&
                Objects.equals(baseUrl, productIcon.baseUrl) &&
                Objects.equals(version, productIcon.version);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("ProductIcon{");
        sb.append("images=").append(images);
        sb.append(", baseUrl=").append(baseUrl);
        sb.append(", version=").append(version);
        sb.append('}');
        return sb.toString();
    }
}
