// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.users;

import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.apps.AppMin;
import com.vk.api.sdk.objects.audio.Audio;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.base.City;
import com.vk.api.sdk.objects.base.Country;
import com.vk.api.sdk.objects.base.CropPhoto;
import com.vk.api.sdk.objects.owner.State;
import com.vk.api.sdk.objects.photos.Photo;
import com.vk.api.sdk.objects.video.LiveInfo;
import java.net.URI;
import java.util.List;
import java.util.Objects;

/**
 * UserFull object
 */
public class UserFull extends User implements Validable {
    @SerializedName("about")
    private String about;

    @SerializedName("access_key")
    private String accessKey;

    @SerializedName("activities")
    private String activities;

    /**
     * User's status
     */
    @SerializedName("activity")
    private String activity;

    /**
     * User's date of birth
     */
    @SerializedName("bdate")
    private String bdate;

    /**
     * Information whether current user is in the requested user's blacklist.
     */
    @SerializedName("blacklisted")
    private BoolInt blacklisted;

    /**
     * Information whether the requested user is in current user's blacklist
     */
    @SerializedName("blacklisted_by_me")
    private BoolInt blacklistedByMe;

    @SerializedName("books")
    private String books;

    /**
     * Information whether the user can be baned (added to black list) by me
     */
    @SerializedName("can_ban")
    private Boolean canBan;

    /**
     * Information whether current user can be invited to the community
     */
    @SerializedName("can_be_invited_group")
    private Boolean canBeInvitedGroup;

    /**
     * Information whether current user can call
     */
    @SerializedName("can_call")
    private Boolean canCall;

    /**
     * Information whether group can call user
     */
    @SerializedName("can_call_from_group")
    private Boolean canCallFromGroup;

    /**
     * Information whether current user can post on the user's wall
     */
    @SerializedName("can_post")
    private BoolInt canPost;

    /**
     * Information whether current user can see other users' audio on the wall
     */
    @SerializedName("can_see_all_posts")
    private BoolInt canSeeAllPosts;

    /**
     * Information whether current user can see the user's audio
     */
    @SerializedName("can_see_audio")
    private BoolInt canSeeAudio;

    /**
     * Information whether current user can see the user's gifts
     */
    @SerializedName("can_see_gifts")
    private BoolInt canSeeGifts;

    /**
     * Information whether current user can see the user's wishes
     */
    @SerializedName("can_see_wishes")
    private Boolean canSeeWishes;

    /**
     * Information whether current user can send a friend request
     */
    @SerializedName("can_send_friend_request")
    private BoolInt canSendFriendRequest;

    /**
     * Owner in whitelist or not
     */
    @SerializedName("can_subscribe_podcasts")
    private Boolean canSubscribePodcasts;

    /**
     * Can subscribe to wall
     */
    @SerializedName("can_subscribe_posts")
    private Boolean canSubscribePosts;

    @SerializedName("can_upload_doc")
    private BoolInt canUploadDoc;

    /**
     * Information whether current user can write private message
     */
    @SerializedName("can_write_private_message")
    private BoolInt canWritePrivateMessage;

    @SerializedName("career")
    private List<Career> career;

    @SerializedName("city")
    private City city;

    /**
     * Number of user's clips
     */
    @SerializedName("clips_count")
    private Integer clipsCount;

    /**
     * Number of common friends with current user
     */
    @SerializedName("common_count")
    private Integer commonCount;

    /**
     * Contact person ID
     */
    @SerializedName("contact_id")
    private Integer contactId;

    /**
     * User contact name
     */
    @SerializedName("contact_name")
    private String contactName;

    @SerializedName("counters")
    private UserCounters counters;

    @SerializedName("country")
    private Country country;

    @SerializedName("crop_photo")
    private CropPhoto cropPhoto;

    @SerializedName("descriptions")
    private List<String> descriptions;

    /**
     * Domain name of the user's page
     */
    @SerializedName("domain")
    private String domain;

    /**
     * Education form
     */
    @SerializedName("education_form")
    private String educationForm;

    /**
     * User's education status
     */
    @SerializedName("education_status")
    private String educationStatus;

    @SerializedName("email")
    private String email;

    @SerializedName("exports")
    private Exports exports;

    @SerializedName("facebook")
    private String facebook;

    @SerializedName("facebook_name")
    private String facebookName;

    /**
     * Faculty ID
     */
    @SerializedName("faculty")
    private Integer faculty;

    /**
     * Faculty name
     */
    @SerializedName("faculty_name")
    private String facultyName;

    /**
     * User's first name in prepositional case
     */
    @SerializedName("first_name_abl")
    private String firstNameAbl;

    /**
     * User's first name in accusative case
     */
    @SerializedName("first_name_acc")
    private String firstNameAcc;

    /**
     * User's first name in dative case
     */
    @SerializedName("first_name_dat")
    private String firstNameDat;

    /**
     * User's first name in genitive case
     */
    @SerializedName("first_name_gen")
    private String firstNameGen;

    /**
     * User's first name in instrumental case
     */
    @SerializedName("first_name_ins")
    private String firstNameIns;

    /**
     * User's first name in nominative case
     */
    @SerializedName("first_name_nom")
    private String firstNameNom;

    /**
     * Number of user's followers
     */
    @SerializedName("followers_count")
    private Integer followersCount;

    @SerializedName("games")
    private String games;

    /**
     * Graduation year
     */
    @SerializedName("graduation")
    private Integer graduation;

    /**
     * Information whether the user specified his phone number
     */
    @SerializedName("has_mobile")
    private BoolInt hasMobile;

    /**
     * Information whether the user has main photo
     */
    @SerializedName("has_photo")
    private BoolInt hasPhoto;

    @SerializedName("has_unseen_stories")
    private Boolean hasUnseenStories;

    @SerializedName("hash")
    private String hash;

    /**
     * User's additional phone number
     */
    @SerializedName("home_phone")
    private String homePhone;

    /**
     * User hometown
     */
    @SerializedName("home_town")
    private String homeTown;

    @SerializedName("instagram")
    private String instagram;

    @SerializedName("interests")
    private String interests;

    /**
     * Information whether the user is a best friend of current user
     */
    @SerializedName("is_best_friend")
    private Boolean isBestFriend;

    /**
     * Information whether the requested user is in faves of current user
     */
    @SerializedName("is_favorite")
    private BoolInt isFavorite;

    /**
     * Information whether the user is a friend of current user
     */
    @SerializedName("is_friend")
    private BoolInt isFriend;

    /**
     * Information whether the requested user is hidden from current user's newsfeed
     */
    @SerializedName("is_hidden_from_feed")
    private BoolInt isHiddenFromFeed;

    @SerializedName("is_message_request")
    private Boolean isMessageRequest;

    /**
     * Access to user profile is restricted for search engines
     */
    @SerializedName("is_no_index")
    private Boolean isNoIndex;

    @SerializedName("is_service")
    private Boolean isService;

    /**
     * Information whether current user is subscribed to podcasts
     */
    @SerializedName("is_subscribed_podcasts")
    private Boolean isSubscribedPodcasts;

    @SerializedName("is_video_live_notifications_blocked")
    private BoolInt isVideoLiveNotificationsBlocked;

    @SerializedName("language")
    private String language;

    /**
     * User's last name in prepositional case
     */
    @SerializedName("last_name_abl")
    private String lastNameAbl;

    /**
     * User's last name in accusative case
     */
    @SerializedName("last_name_acc")
    private String lastNameAcc;

    /**
     * User's last name in dative case
     */
    @SerializedName("last_name_dat")
    private String lastNameDat;

    /**
     * User's last name in genitive case
     */
    @SerializedName("last_name_gen")
    private String lastNameGen;

    /**
     * User's last name in instrumental case
     */
    @SerializedName("last_name_ins")
    private String lastNameIns;

    /**
     * User's last name in nominative case
     */
    @SerializedName("last_name_nom")
    private String lastNameNom;

    @SerializedName("last_seen")
    private LastSeen lastSeen;

    @SerializedName("lists")
    private List<Integer> lists;

    @SerializedName("livejournal")
    private String livejournal;

    /**
     * User maiden name
     */
    @SerializedName("maiden_name")
    private String maidenName;

    @SerializedName("military")
    private List<Military> military;

    /**
     * User's mobile phone number
     */
    @SerializedName("mobile_phone")
    private String mobilePhone;

    @SerializedName("movies")
    private String movies;

    @SerializedName("music")
    private String music;

    /**
     * User nickname
     */
    @SerializedName("nickname")
    private String nickname;

    @SerializedName("occupation")
    private Occupation occupation;

    @SerializedName("owner_state")
    private State ownerState;

    @SerializedName("personal")
    private Personal personal;

    @SerializedName("photo")
    private String photo;

    /**
     * URL of square photo of the user with 200 pixels in width
     */
    @SerializedName("photo_200")
    private URI photo200;

    /**
     * URL of user's photo with 200 pixels in width
     */
    @SerializedName("photo_200_orig")
    private URI photo200Orig;

    @SerializedName("photo_400")
    private String photo400;

    /**
     * URL of user's photo with 400 pixels in width
     */
    @SerializedName("photo_400_orig")
    private URI photo400Orig;

    @SerializedName("photo_big")
    private String photoBig;

    /**
     * ID of the user's main photo
     */
    @SerializedName("photo_id")
    private String photoId;

    /**
     * URL of square photo of the user with maximum width
     */
    @SerializedName("photo_max")
    private URI photoMax;

    /**
     * URL of user's photo of maximum size
     */
    @SerializedName("photo_max_orig")
    private URI photoMaxOrig;

    @SerializedName("photo_max_size")
    private Photo photoMaxSize;

    @SerializedName("photo_medium")
    private JsonPrimitive photoMedium;

    @SerializedName("photo_medium_rec")
    private JsonPrimitive photoMediumRec;

    @SerializedName("photo_rec")
    private JsonPrimitive photoRec;

    @SerializedName("quotes")
    private String quotes;

    /**
     * User relationship status
     */
    @SerializedName("relation")
    private UserRelation relation;

    @SerializedName("relation_partner")
    private UserMin relationPartner;

    @SerializedName("relatives")
    private List<Relative> relatives;

    @SerializedName("schools")
    private List<School> schools;

    @SerializedName("service_description")
    private String serviceDescription;

    /**
     * User's website
     */
    @SerializedName("site")
    private String site;

    @SerializedName("skype")
    private String skype;

    /**
     * User's status
     */
    @SerializedName("status")
    private String status;

    @SerializedName("status_app")
    private AppMin statusApp;

    @SerializedName("status_audio")
    private Audio statusAudio;

    @SerializedName("stories_archive_count")
    private Integer storiesArchiveCount;

    @SerializedName("test")
    private BoolInt test;

    /**
     * User's timezone
     */
    @SerializedName("timezone")
    private Number timezone;

    @SerializedName("tv")
    private String tv;

    @SerializedName("twitter")
    private String twitter;

    @SerializedName("type")
    private UserType type;

    @SerializedName("universities")
    private List<University> universities;

    /**
     * University ID
     */
    @SerializedName("university")
    private Integer university;

    @SerializedName("university_group_id")
    private Integer universityGroupId;

    /**
     * University name
     */
    @SerializedName("university_name")
    private String universityName;

    @SerializedName("video_live")
    private LiveInfo videoLive;

    /**
     * Number of user's live streams
     */
    @SerializedName("video_live_count")
    private Integer videoLiveCount;

    /**
     * User level in live streams achievements
     */
    @SerializedName("video_live_level")
    private Integer videoLiveLevel;

    /**
     * Information whether current user can comment wall posts
     */
    @SerializedName("wall_comments")
    private BoolInt wallComments;

    @SerializedName("wall_default")
    private UserFullWallDefault wallDefault;

    public String getAbout() {
        return about;
    }

    public UserFull setAbout(String about) {
        this.about = about;
        return this;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public UserFull setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public String getActivities() {
        return activities;
    }

    public UserFull setActivities(String activities) {
        this.activities = activities;
        return this;
    }

    public String getActivity() {
        return activity;
    }

    public UserFull setActivity(String activity) {
        this.activity = activity;
        return this;
    }

    public String getBdate() {
        return bdate;
    }

    public UserFull setBdate(String bdate) {
        this.bdate = bdate;
        return this;
    }

    public boolean isBlacklisted() {
        return blacklisted == BoolInt.YES;
    }

    public BoolInt getBlacklisted() {
        return blacklisted;
    }

    public boolean isBlacklistedByMe() {
        return blacklistedByMe == BoolInt.YES;
    }

    public BoolInt getBlacklistedByMe() {
        return blacklistedByMe;
    }

    public String getBooks() {
        return books;
    }

    public UserFull setBooks(String books) {
        this.books = books;
        return this;
    }

    public Boolean getCanBan() {
        return canBan;
    }

    public UserFull setCanBan(Boolean canBan) {
        this.canBan = canBan;
        return this;
    }

    public Boolean getCanBeInvitedGroup() {
        return canBeInvitedGroup;
    }

    public UserFull setCanBeInvitedGroup(Boolean canBeInvitedGroup) {
        this.canBeInvitedGroup = canBeInvitedGroup;
        return this;
    }

    public Boolean getCanCall() {
        return canCall;
    }

    public UserFull setCanCall(Boolean canCall) {
        this.canCall = canCall;
        return this;
    }

    public Boolean getCanCallFromGroup() {
        return canCallFromGroup;
    }

    public UserFull setCanCallFromGroup(Boolean canCallFromGroup) {
        this.canCallFromGroup = canCallFromGroup;
        return this;
    }

    public boolean canPost() {
        return canPost == BoolInt.YES;
    }

    public BoolInt getCanPost() {
        return canPost;
    }

    public boolean canSeeAllPosts() {
        return canSeeAllPosts == BoolInt.YES;
    }

    public BoolInt getCanSeeAllPosts() {
        return canSeeAllPosts;
    }

    public boolean canSeeAudio() {
        return canSeeAudio == BoolInt.YES;
    }

    public BoolInt getCanSeeAudio() {
        return canSeeAudio;
    }

    public boolean canSeeGifts() {
        return canSeeGifts == BoolInt.YES;
    }

    public BoolInt getCanSeeGifts() {
        return canSeeGifts;
    }

    public Boolean getCanSeeWishes() {
        return canSeeWishes;
    }

    public UserFull setCanSeeWishes(Boolean canSeeWishes) {
        this.canSeeWishes = canSeeWishes;
        return this;
    }

    public boolean canSendFriendRequest() {
        return canSendFriendRequest == BoolInt.YES;
    }

    public BoolInt getCanSendFriendRequest() {
        return canSendFriendRequest;
    }

    public Boolean getCanSubscribePodcasts() {
        return canSubscribePodcasts;
    }

    public UserFull setCanSubscribePodcasts(Boolean canSubscribePodcasts) {
        this.canSubscribePodcasts = canSubscribePodcasts;
        return this;
    }

    public Boolean getCanSubscribePosts() {
        return canSubscribePosts;
    }

    public UserFull setCanSubscribePosts(Boolean canSubscribePosts) {
        this.canSubscribePosts = canSubscribePosts;
        return this;
    }

    public boolean canUploadDoc() {
        return canUploadDoc == BoolInt.YES;
    }

    public BoolInt getCanUploadDoc() {
        return canUploadDoc;
    }

    public boolean canWritePrivateMessage() {
        return canWritePrivateMessage == BoolInt.YES;
    }

    public BoolInt getCanWritePrivateMessage() {
        return canWritePrivateMessage;
    }

    public List<Career> getCareer() {
        return career;
    }

    public UserFull setCareer(List<Career> career) {
        this.career = career;
        return this;
    }

    public City getCity() {
        return city;
    }

    public UserFull setCity(City city) {
        this.city = city;
        return this;
    }

    public Integer getClipsCount() {
        return clipsCount;
    }

    public UserFull setClipsCount(Integer clipsCount) {
        this.clipsCount = clipsCount;
        return this;
    }

    public Integer getCommonCount() {
        return commonCount;
    }

    public UserFull setCommonCount(Integer commonCount) {
        this.commonCount = commonCount;
        return this;
    }

    public Integer getContactId() {
        return contactId;
    }

    public UserFull setContactId(Integer contactId) {
        this.contactId = contactId;
        return this;
    }

    public String getContactName() {
        return contactName;
    }

    public UserFull setContactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    public UserCounters getCounters() {
        return counters;
    }

    public UserFull setCounters(UserCounters counters) {
        this.counters = counters;
        return this;
    }

    public Country getCountry() {
        return country;
    }

    public UserFull setCountry(Country country) {
        this.country = country;
        return this;
    }

    public CropPhoto getCropPhoto() {
        return cropPhoto;
    }

    public UserFull setCropPhoto(CropPhoto cropPhoto) {
        this.cropPhoto = cropPhoto;
        return this;
    }

    public List<String> getDescriptions() {
        return descriptions;
    }

    public UserFull setDescriptions(List<String> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public UserFull setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getEducationForm() {
        return educationForm;
    }

    public UserFull setEducationForm(String educationForm) {
        this.educationForm = educationForm;
        return this;
    }

    public String getEducationStatus() {
        return educationStatus;
    }

    public UserFull setEducationStatus(String educationStatus) {
        this.educationStatus = educationStatus;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public UserFull setEmail(String email) {
        this.email = email;
        return this;
    }

    public Exports getExports() {
        return exports;
    }

    public UserFull setExports(Exports exports) {
        this.exports = exports;
        return this;
    }

    public String getFacebook() {
        return facebook;
    }

    public UserFull setFacebook(String facebook) {
        this.facebook = facebook;
        return this;
    }

    public String getFacebookName() {
        return facebookName;
    }

    public UserFull setFacebookName(String facebookName) {
        this.facebookName = facebookName;
        return this;
    }

    public Integer getFaculty() {
        return faculty;
    }

    public UserFull setFaculty(Integer faculty) {
        this.faculty = faculty;
        return this;
    }

    public String getFacultyName() {
        return facultyName;
    }

    public UserFull setFacultyName(String facultyName) {
        this.facultyName = facultyName;
        return this;
    }

    public String getFirstNameAbl() {
        return firstNameAbl;
    }

    public UserFull setFirstNameAbl(String firstNameAbl) {
        this.firstNameAbl = firstNameAbl;
        return this;
    }

    public String getFirstNameAcc() {
        return firstNameAcc;
    }

    public UserFull setFirstNameAcc(String firstNameAcc) {
        this.firstNameAcc = firstNameAcc;
        return this;
    }

    public String getFirstNameDat() {
        return firstNameDat;
    }

    public UserFull setFirstNameDat(String firstNameDat) {
        this.firstNameDat = firstNameDat;
        return this;
    }

    public String getFirstNameGen() {
        return firstNameGen;
    }

    public UserFull setFirstNameGen(String firstNameGen) {
        this.firstNameGen = firstNameGen;
        return this;
    }

    public String getFirstNameIns() {
        return firstNameIns;
    }

    public UserFull setFirstNameIns(String firstNameIns) {
        this.firstNameIns = firstNameIns;
        return this;
    }

    public String getFirstNameNom() {
        return firstNameNom;
    }

    public UserFull setFirstNameNom(String firstNameNom) {
        this.firstNameNom = firstNameNom;
        return this;
    }

    public Integer getFollowersCount() {
        return followersCount;
    }

    public UserFull setFollowersCount(Integer followersCount) {
        this.followersCount = followersCount;
        return this;
    }

    public String getGames() {
        return games;
    }

    public UserFull setGames(String games) {
        this.games = games;
        return this;
    }

    public Integer getGraduation() {
        return graduation;
    }

    public UserFull setGraduation(Integer graduation) {
        this.graduation = graduation;
        return this;
    }

    public boolean isHasMobile() {
        return hasMobile == BoolInt.YES;
    }

    public BoolInt getHasMobile() {
        return hasMobile;
    }

    public boolean isHasPhoto() {
        return hasPhoto == BoolInt.YES;
    }

    public BoolInt getHasPhoto() {
        return hasPhoto;
    }

    public Boolean getHasUnseenStories() {
        return hasUnseenStories;
    }

    public UserFull setHasUnseenStories(Boolean hasUnseenStories) {
        this.hasUnseenStories = hasUnseenStories;
        return this;
    }

    public String getHash() {
        return hash;
    }

    public UserFull setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public String getHomePhone() {
        return homePhone;
    }

    public UserFull setHomePhone(String homePhone) {
        this.homePhone = homePhone;
        return this;
    }

    public String getHomeTown() {
        return homeTown;
    }

    public UserFull setHomeTown(String homeTown) {
        this.homeTown = homeTown;
        return this;
    }

    public String getInstagram() {
        return instagram;
    }

    public UserFull setInstagram(String instagram) {
        this.instagram = instagram;
        return this;
    }

    public String getInterests() {
        return interests;
    }

    public UserFull setInterests(String interests) {
        this.interests = interests;
        return this;
    }

    public Boolean getIsBestFriend() {
        return isBestFriend;
    }

    public UserFull setIsBestFriend(Boolean isBestFriend) {
        this.isBestFriend = isBestFriend;
        return this;
    }

    public boolean isFavorite() {
        return isFavorite == BoolInt.YES;
    }

    public BoolInt getIsFavorite() {
        return isFavorite;
    }

    public boolean isFriend() {
        return isFriend == BoolInt.YES;
    }

    public BoolInt getIsFriend() {
        return isFriend;
    }

    public boolean isHiddenFromFeed() {
        return isHiddenFromFeed == BoolInt.YES;
    }

    public BoolInt getIsHiddenFromFeed() {
        return isHiddenFromFeed;
    }

    public Boolean getIsMessageRequest() {
        return isMessageRequest;
    }

    public UserFull setIsMessageRequest(Boolean isMessageRequest) {
        this.isMessageRequest = isMessageRequest;
        return this;
    }

    public Boolean getIsNoIndex() {
        return isNoIndex;
    }

    public UserFull setIsNoIndex(Boolean isNoIndex) {
        this.isNoIndex = isNoIndex;
        return this;
    }

    public Boolean getIsService() {
        return isService;
    }

    public UserFull setIsService(Boolean isService) {
        this.isService = isService;
        return this;
    }

    public Boolean getIsSubscribedPodcasts() {
        return isSubscribedPodcasts;
    }

    public UserFull setIsSubscribedPodcasts(Boolean isSubscribedPodcasts) {
        this.isSubscribedPodcasts = isSubscribedPodcasts;
        return this;
    }

    public boolean isVideoLiveNotificationsBlocked() {
        return isVideoLiveNotificationsBlocked == BoolInt.YES;
    }

    public BoolInt getIsVideoLiveNotificationsBlocked() {
        return isVideoLiveNotificationsBlocked;
    }

    public String getLanguage() {
        return language;
    }

    public UserFull setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getLastNameAbl() {
        return lastNameAbl;
    }

    public UserFull setLastNameAbl(String lastNameAbl) {
        this.lastNameAbl = lastNameAbl;
        return this;
    }

    public String getLastNameAcc() {
        return lastNameAcc;
    }

    public UserFull setLastNameAcc(String lastNameAcc) {
        this.lastNameAcc = lastNameAcc;
        return this;
    }

    public String getLastNameDat() {
        return lastNameDat;
    }

    public UserFull setLastNameDat(String lastNameDat) {
        this.lastNameDat = lastNameDat;
        return this;
    }

    public String getLastNameGen() {
        return lastNameGen;
    }

    public UserFull setLastNameGen(String lastNameGen) {
        this.lastNameGen = lastNameGen;
        return this;
    }

    public String getLastNameIns() {
        return lastNameIns;
    }

    public UserFull setLastNameIns(String lastNameIns) {
        this.lastNameIns = lastNameIns;
        return this;
    }

    public String getLastNameNom() {
        return lastNameNom;
    }

    public UserFull setLastNameNom(String lastNameNom) {
        this.lastNameNom = lastNameNom;
        return this;
    }

    public LastSeen getLastSeen() {
        return lastSeen;
    }

    public UserFull setLastSeen(LastSeen lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    public List<Integer> getLists() {
        return lists;
    }

    public UserFull setLists(List<Integer> lists) {
        this.lists = lists;
        return this;
    }

    public String getLivejournal() {
        return livejournal;
    }

    public UserFull setLivejournal(String livejournal) {
        this.livejournal = livejournal;
        return this;
    }

    public String getMaidenName() {
        return maidenName;
    }

    public UserFull setMaidenName(String maidenName) {
        this.maidenName = maidenName;
        return this;
    }

    public List<Military> getMilitary() {
        return military;
    }

    public UserFull setMilitary(List<Military> military) {
        this.military = military;
        return this;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public UserFull setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public String getMovies() {
        return movies;
    }

    public UserFull setMovies(String movies) {
        this.movies = movies;
        return this;
    }

    public String getMusic() {
        return music;
    }

    public UserFull setMusic(String music) {
        this.music = music;
        return this;
    }

    public String getNickname() {
        return nickname;
    }

    public UserFull setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public Occupation getOccupation() {
        return occupation;
    }

    public UserFull setOccupation(Occupation occupation) {
        this.occupation = occupation;
        return this;
    }

    public State getOwnerState() {
        return ownerState;
    }

    public UserFull setOwnerState(State ownerState) {
        this.ownerState = ownerState;
        return this;
    }

    public Personal getPersonal() {
        return personal;
    }

    public UserFull setPersonal(Personal personal) {
        this.personal = personal;
        return this;
    }

    public String getPhoto() {
        return photo;
    }

    public UserFull setPhoto(String photo) {
        this.photo = photo;
        return this;
    }

    public URI getPhoto200() {
        return photo200;
    }

    public UserFull setPhoto200(URI photo200) {
        this.photo200 = photo200;
        return this;
    }

    public URI getPhoto200Orig() {
        return photo200Orig;
    }

    public UserFull setPhoto200Orig(URI photo200Orig) {
        this.photo200Orig = photo200Orig;
        return this;
    }

    public String getPhoto400() {
        return photo400;
    }

    public UserFull setPhoto400(String photo400) {
        this.photo400 = photo400;
        return this;
    }

    public URI getPhoto400Orig() {
        return photo400Orig;
    }

    public UserFull setPhoto400Orig(URI photo400Orig) {
        this.photo400Orig = photo400Orig;
        return this;
    }

    public String getPhotoBig() {
        return photoBig;
    }

    public UserFull setPhotoBig(String photoBig) {
        this.photoBig = photoBig;
        return this;
    }

    public String getPhotoId() {
        return photoId;
    }

    public UserFull setPhotoId(String photoId) {
        this.photoId = photoId;
        return this;
    }

    public URI getPhotoMax() {
        return photoMax;
    }

    public UserFull setPhotoMax(URI photoMax) {
        this.photoMax = photoMax;
        return this;
    }

    public URI getPhotoMaxOrig() {
        return photoMaxOrig;
    }

    public UserFull setPhotoMaxOrig(URI photoMaxOrig) {
        this.photoMaxOrig = photoMaxOrig;
        return this;
    }

    public Photo getPhotoMaxSize() {
        return photoMaxSize;
    }

    public UserFull setPhotoMaxSize(Photo photoMaxSize) {
        this.photoMaxSize = photoMaxSize;
        return this;
    }

    public JsonPrimitive getPhotoMedium() {
        return photoMedium;
    }

    public UserFull setPhotoMedium(JsonPrimitive photoMedium) {
        this.photoMedium = photoMedium;
        return this;
    }

    public JsonPrimitive getPhotoMediumRec() {
        return photoMediumRec;
    }

    public UserFull setPhotoMediumRec(JsonPrimitive photoMediumRec) {
        this.photoMediumRec = photoMediumRec;
        return this;
    }

    public JsonPrimitive getPhotoRec() {
        return photoRec;
    }

    public UserFull setPhotoRec(JsonPrimitive photoRec) {
        this.photoRec = photoRec;
        return this;
    }

    public String getQuotes() {
        return quotes;
    }

    public UserFull setQuotes(String quotes) {
        this.quotes = quotes;
        return this;
    }

    public UserRelation getRelation() {
        return relation;
    }

    public UserFull setRelation(UserRelation relation) {
        this.relation = relation;
        return this;
    }

    public UserMin getRelationPartner() {
        return relationPartner;
    }

    public UserFull setRelationPartner(UserMin relationPartner) {
        this.relationPartner = relationPartner;
        return this;
    }

    public List<Relative> getRelatives() {
        return relatives;
    }

    public UserFull setRelatives(List<Relative> relatives) {
        this.relatives = relatives;
        return this;
    }

    public List<School> getSchools() {
        return schools;
    }

    public UserFull setSchools(List<School> schools) {
        this.schools = schools;
        return this;
    }

    public String getServiceDescription() {
        return serviceDescription;
    }

    public UserFull setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
        return this;
    }

    public String getSite() {
        return site;
    }

    public UserFull setSite(String site) {
        this.site = site;
        return this;
    }

    public String getSkype() {
        return skype;
    }

    public UserFull setSkype(String skype) {
        this.skype = skype;
        return this;
    }

    public String getStatus() {
        return status;
    }

    public UserFull setStatus(String status) {
        this.status = status;
        return this;
    }

    public AppMin getStatusApp() {
        return statusApp;
    }

    public UserFull setStatusApp(AppMin statusApp) {
        this.statusApp = statusApp;
        return this;
    }

    public Audio getStatusAudio() {
        return statusAudio;
    }

    public UserFull setStatusAudio(Audio statusAudio) {
        this.statusAudio = statusAudio;
        return this;
    }

    public Integer getStoriesArchiveCount() {
        return storiesArchiveCount;
    }

    public UserFull setStoriesArchiveCount(Integer storiesArchiveCount) {
        this.storiesArchiveCount = storiesArchiveCount;
        return this;
    }

    public boolean isTest() {
        return test == BoolInt.YES;
    }

    public BoolInt getTest() {
        return test;
    }

    public Number getTimezone() {
        return timezone;
    }

    public UserFull setTimezone(Number timezone) {
        this.timezone = timezone;
        return this;
    }

    public String getTv() {
        return tv;
    }

    public UserFull setTv(String tv) {
        this.tv = tv;
        return this;
    }

    public String getTwitter() {
        return twitter;
    }

    public UserFull setTwitter(String twitter) {
        this.twitter = twitter;
        return this;
    }

    public UserType getType() {
        return type;
    }

    public UserFull setType(UserType type) {
        this.type = type;
        return this;
    }

    public List<University> getUniversities() {
        return universities;
    }

    public UserFull setUniversities(List<University> universities) {
        this.universities = universities;
        return this;
    }

    public Integer getUniversity() {
        return university;
    }

    public UserFull setUniversity(Integer university) {
        this.university = university;
        return this;
    }

    public Integer getUniversityGroupId() {
        return universityGroupId;
    }

    public UserFull setUniversityGroupId(Integer universityGroupId) {
        this.universityGroupId = universityGroupId;
        return this;
    }

    public String getUniversityName() {
        return universityName;
    }

    public UserFull setUniversityName(String universityName) {
        this.universityName = universityName;
        return this;
    }

    public LiveInfo getVideoLive() {
        return videoLive;
    }

    public UserFull setVideoLive(LiveInfo videoLive) {
        this.videoLive = videoLive;
        return this;
    }

    public Integer getVideoLiveCount() {
        return videoLiveCount;
    }

    public UserFull setVideoLiveCount(Integer videoLiveCount) {
        this.videoLiveCount = videoLiveCount;
        return this;
    }

    public Integer getVideoLiveLevel() {
        return videoLiveLevel;
    }

    public UserFull setVideoLiveLevel(Integer videoLiveLevel) {
        this.videoLiveLevel = videoLiveLevel;
        return this;
    }

    public boolean isWallComments() {
        return wallComments == BoolInt.YES;
    }

    public BoolInt getWallComments() {
        return wallComments;
    }

    public UserFullWallDefault getWallDefault() {
        return wallDefault;
    }

    public UserFull setWallDefault(UserFullWallDefault wallDefault) {
        this.wallDefault = wallDefault;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(canBeInvitedGroup, career, occupation, isNoIndex, about, instagram, type, quotes, relation, movies, ownerState, twitter, music, universities, homeTown, graduation, games, storiesArchiveCount, lastNameIns, firstNameGen, counters, contactId, canSeeAllPosts, photoMediumRec, personal, educationStatus, videoLiveCount, books, lastSeen, canSubscribePodcasts, hasPhoto, mobilePhone, schools, domain, lastNameNom, facultyName, followersCount, hash, facebookName, statusAudio, status, isMessageRequest, activity, city, maidenName, photo200, videoLiveLevel, skype, canPost, photoMaxSize, statusApp, canSeeGifts, nickname, wallDefault, commonCount, email, isVideoLiveNotificationsBlocked, photoBig, lastNameDat, canBan, facebook, videoLive, photoId, photo, photo200Orig, lastNameAcc, blacklisted, site, firstNameIns, interests, canSendFriendRequest, universityName, country, isBestFriend, canSubscribePosts, tv, bdate, language, educationForm, descriptions, faculty, canSeeAudio, photoMaxOrig, hasUnseenStories, military, firstNameNom, lastNameAbl, isService, canCallFromGroup, test, contactName, homePhone, livejournal, relatives, canUploadDoc, accessKey, lists, photo400Orig, isHiddenFromFeed, lastNameGen, isFavorite, relationPartner, cropPhoto, exports, timezone, university, isSubscribedPodcasts, photoMedium, photo400, firstNameAcc, clipsCount, universityGroupId, firstNameDat, wallComments, photoMax, isFriend, canSeeWishes, hasMobile, blacklistedByMe, canCall, photoRec, activities, firstNameAbl, serviceDescription, canWritePrivateMessage);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserFull userFull = (UserFull) o;
        return Objects.equals(canCall, userFull.canCall) &&
                Objects.equals(career, userFull.career) &&
                Objects.equals(universityGroupId, userFull.universityGroupId) &&
                Objects.equals(occupation, userFull.occupation) &&
                Objects.equals(about, userFull.about) &&
                Objects.equals(hasUnseenStories, userFull.hasUnseenStories) &&
                Objects.equals(photoBig, userFull.photoBig) &&
                Objects.equals(instagram, userFull.instagram) &&
                Objects.equals(type, userFull.type) &&
                Objects.equals(statusAudio, userFull.statusAudio) &&
                Objects.equals(quotes, userFull.quotes) &&
                Objects.equals(relation, userFull.relation) &&
                Objects.equals(isService, userFull.isService) &&
                Objects.equals(movies, userFull.movies) &&
                Objects.equals(firstNameGen, userFull.firstNameGen) &&
                Objects.equals(relationPartner, userFull.relationPartner) &&
                Objects.equals(storiesArchiveCount, userFull.storiesArchiveCount) &&
                Objects.equals(twitter, userFull.twitter) &&
                Objects.equals(music, userFull.music) &&
                Objects.equals(photoMaxSize, userFull.photoMaxSize) &&
                Objects.equals(universities, userFull.universities) &&
                Objects.equals(graduation, userFull.graduation) &&
                Objects.equals(games, userFull.games) &&
                Objects.equals(lastNameNom, userFull.lastNameNom) &&
                Objects.equals(canCallFromGroup, userFull.canCallFromGroup) &&
                Objects.equals(canSeeAllPosts, userFull.canSeeAllPosts) &&
                Objects.equals(canSeeWishes, userFull.canSeeWishes) &&
                Objects.equals(commonCount, userFull.commonCount) &&
                Objects.equals(counters, userFull.counters) &&
                Objects.equals(firstNameAcc, userFull.firstNameAcc) &&
                Objects.equals(personal, userFull.personal) &&
                Objects.equals(photoMediumRec, userFull.photoMediumRec) &&
                Objects.equals(books, userFull.books) &&
                Objects.equals(isSubscribedPodcasts, userFull.isSubscribedPodcasts) &&
                Objects.equals(schools, userFull.schools) &&
                Objects.equals(domain, userFull.domain) &&
                Objects.equals(firstNameAbl, userFull.firstNameAbl) &&
                Objects.equals(hash, userFull.hash) &&
                Objects.equals(status, userFull.status) &&
                Objects.equals(hasMobile, userFull.hasMobile) &&
                Objects.equals(activity, userFull.activity) &&
                Objects.equals(photoId, userFull.photoId) &&
                Objects.equals(city, userFull.city) &&
                Objects.equals(canSeeGifts, userFull.canSeeGifts) &&
                Objects.equals(hasPhoto, userFull.hasPhoto) &&
                Objects.equals(skype, userFull.skype) &&
                Objects.equals(nickname, userFull.nickname) &&
                Objects.equals(photo200, userFull.photo200) &&
                Objects.equals(email, userFull.email) &&
                Objects.equals(contactName, userFull.contactName) &&
                Objects.equals(isVideoLiveNotificationsBlocked, userFull.isVideoLiveNotificationsBlocked) &&
                Objects.equals(facebook, userFull.facebook) &&
                Objects.equals(photo, userFull.photo) &&
                Objects.equals(educationStatus, userFull.educationStatus) &&
                Objects.equals(photoMedium, userFull.photoMedium) &&
                Objects.equals(blacklisted, userFull.blacklisted) &&
                Objects.equals(site, userFull.site) &&
                Objects.equals(wallDefault, userFull.wallDefault) &&
                Objects.equals(cropPhoto, userFull.cropPhoto) &&
                Objects.equals(lastNameIns, userFull.lastNameIns) &&
                Objects.equals(photoRec, userFull.photoRec) &&
                Objects.equals(interests, userFull.interests) &&
                Objects.equals(isFriend, userFull.isFriend) &&
                Objects.equals(country, userFull.country) &&
                Objects.equals(tv, userFull.tv) &&
                Objects.equals(bdate, userFull.bdate) &&
                Objects.equals(canSendFriendRequest, userFull.canSendFriendRequest) &&
                Objects.equals(lastSeen, userFull.lastSeen) &&
                Objects.equals(blacklistedByMe, userFull.blacklistedByMe) &&
                Objects.equals(language, userFull.language) &&
                Objects.equals(descriptions, userFull.descriptions) &&
                Objects.equals(educationForm, userFull.educationForm) &&
                Objects.equals(faculty, userFull.faculty) &&
                Objects.equals(canSubscribePodcasts, userFull.canSubscribePodcasts) &&
                Objects.equals(isNoIndex, userFull.isNoIndex) &&
                Objects.equals(statusApp, userFull.statusApp) &&
                Objects.equals(military, userFull.military) &&
                Objects.equals(lastNameGen, userFull.lastNameGen) &&
                Objects.equals(firstNameNom, userFull.firstNameNom) &&
                Objects.equals(homePhone, userFull.homePhone) &&
                Objects.equals(test, userFull.test) &&
                Objects.equals(videoLiveCount, userFull.videoLiveCount) &&
                Objects.equals(livejournal, userFull.livejournal) &&
                Objects.equals(isMessageRequest, userFull.isMessageRequest) &&
                Objects.equals(relatives, userFull.relatives) &&
                Objects.equals(photoMax, userFull.photoMax) &&
                Objects.equals(canSeeAudio, userFull.canSeeAudio) &&
                Objects.equals(firstNameIns, userFull.firstNameIns) &&
                Objects.equals(homeTown, userFull.homeTown) &&
                Objects.equals(lists, userFull.lists) &&
                Objects.equals(canBeInvitedGroup, userFull.canBeInvitedGroup) &&
                Objects.equals(ownerState, userFull.ownerState) &&
                Objects.equals(videoLive, userFull.videoLive) &&
                Objects.equals(photo200Orig, userFull.photo200Orig) &&
                Objects.equals(photo400Orig, userFull.photo400Orig) &&
                Objects.equals(clipsCount, userFull.clipsCount) &&
                Objects.equals(isFavorite, userFull.isFavorite) &&
                Objects.equals(exports, userFull.exports) &&
                Objects.equals(isBestFriend, userFull.isBestFriend) &&
                Objects.equals(timezone, userFull.timezone) &&
                Objects.equals(university, userFull.university) &&
                Objects.equals(canSubscribePosts, userFull.canSubscribePosts) &&
                Objects.equals(firstNameDat, userFull.firstNameDat) &&
                Objects.equals(contactId, userFull.contactId) &&
                Objects.equals(facultyName, userFull.facultyName) &&
                Objects.equals(photoMaxOrig, userFull.photoMaxOrig) &&
                Objects.equals(lastNameDat, userFull.lastNameDat) &&
                Objects.equals(mobilePhone, userFull.mobilePhone) &&
                Objects.equals(isHiddenFromFeed, userFull.isHiddenFromFeed) &&
                Objects.equals(canPost, userFull.canPost) &&
                Objects.equals(photo400, userFull.photo400) &&
                Objects.equals(maidenName, userFull.maidenName) &&
                Objects.equals(serviceDescription, userFull.serviceDescription) &&
                Objects.equals(wallComments, userFull.wallComments) &&
                Objects.equals(canBan, userFull.canBan) &&
                Objects.equals(videoLiveLevel, userFull.videoLiveLevel) &&
                Objects.equals(universityName, userFull.universityName) &&
                Objects.equals(canUploadDoc, userFull.canUploadDoc) &&
                Objects.equals(lastNameAcc, userFull.lastNameAcc) &&
                Objects.equals(canWritePrivateMessage, userFull.canWritePrivateMessage) &&
                Objects.equals(activities, userFull.activities) &&
                Objects.equals(accessKey, userFull.accessKey) &&
                Objects.equals(followersCount, userFull.followersCount) &&
                Objects.equals(facebookName, userFull.facebookName) &&
                Objects.equals(lastNameAbl, userFull.lastNameAbl);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("UserFull{");
        sb.append("canCall=").append(canCall);
        sb.append(", career=").append(career);
        sb.append(", universityGroupId=").append(universityGroupId);
        sb.append(", occupation=").append(occupation);
        sb.append(", about='").append(about).append("'");
        sb.append(", hasUnseenStories=").append(hasUnseenStories);
        sb.append(", photoBig='").append(photoBig).append("'");
        sb.append(", instagram='").append(instagram).append("'");
        sb.append(", type=").append(type);
        sb.append(", statusAudio=").append(statusAudio);
        sb.append(", quotes='").append(quotes).append("'");
        sb.append(", relation=").append(relation);
        sb.append(", isService=").append(isService);
        sb.append(", movies='").append(movies).append("'");
        sb.append(", firstNameGen='").append(firstNameGen).append("'");
        sb.append(", relationPartner=").append(relationPartner);
        sb.append(", storiesArchiveCount=").append(storiesArchiveCount);
        sb.append(", twitter='").append(twitter).append("'");
        sb.append(", music='").append(music).append("'");
        sb.append(", photoMaxSize=").append(photoMaxSize);
        sb.append(", universities=").append(universities);
        sb.append(", graduation=").append(graduation);
        sb.append(", games='").append(games).append("'");
        sb.append(", lastNameNom='").append(lastNameNom).append("'");
        sb.append(", canCallFromGroup=").append(canCallFromGroup);
        sb.append(", canSeeAllPosts=").append(canSeeAllPosts);
        sb.append(", canSeeWishes=").append(canSeeWishes);
        sb.append(", commonCount=").append(commonCount);
        sb.append(", counters=").append(counters);
        sb.append(", firstNameAcc='").append(firstNameAcc).append("'");
        sb.append(", personal=").append(personal);
        sb.append(", photoMediumRec=").append(photoMediumRec);
        sb.append(", books='").append(books).append("'");
        sb.append(", isSubscribedPodcasts=").append(isSubscribedPodcasts);
        sb.append(", schools=").append(schools);
        sb.append(", domain='").append(domain).append("'");
        sb.append(", firstNameAbl='").append(firstNameAbl).append("'");
        sb.append(", hash='").append(hash).append("'");
        sb.append(", status='").append(status).append("'");
        sb.append(", hasMobile=").append(hasMobile);
        sb.append(", activity='").append(activity).append("'");
        sb.append(", photoId='").append(photoId).append("'");
        sb.append(", city=").append(city);
        sb.append(", canSeeGifts=").append(canSeeGifts);
        sb.append(", hasPhoto=").append(hasPhoto);
        sb.append(", skype='").append(skype).append("'");
        sb.append(", nickname='").append(nickname).append("'");
        sb.append(", photo200=").append(photo200);
        sb.append(", email='").append(email).append("'");
        sb.append(", contactName='").append(contactName).append("'");
        sb.append(", isVideoLiveNotificationsBlocked=").append(isVideoLiveNotificationsBlocked);
        sb.append(", facebook='").append(facebook).append("'");
        sb.append(", photo='").append(photo).append("'");
        sb.append(", educationStatus='").append(educationStatus).append("'");
        sb.append(", photoMedium=").append(photoMedium);
        sb.append(", blacklisted=").append(blacklisted);
        sb.append(", site='").append(site).append("'");
        sb.append(", wallDefault='").append(wallDefault).append("'");
        sb.append(", cropPhoto=").append(cropPhoto);
        sb.append(", lastNameIns='").append(lastNameIns).append("'");
        sb.append(", photoRec=").append(photoRec);
        sb.append(", interests='").append(interests).append("'");
        sb.append(", isFriend=").append(isFriend);
        sb.append(", country=").append(country);
        sb.append(", tv='").append(tv).append("'");
        sb.append(", bdate='").append(bdate).append("'");
        sb.append(", canSendFriendRequest=").append(canSendFriendRequest);
        sb.append(", lastSeen=").append(lastSeen);
        sb.append(", blacklistedByMe=").append(blacklistedByMe);
        sb.append(", language='").append(language).append("'");
        sb.append(", descriptions='").append(descriptions).append("'");
        sb.append(", educationForm='").append(educationForm).append("'");
        sb.append(", faculty=").append(faculty);
        sb.append(", canSubscribePodcasts=").append(canSubscribePodcasts);
        sb.append(", isNoIndex=").append(isNoIndex);
        sb.append(", statusApp=").append(statusApp);
        sb.append(", military=").append(military);
        sb.append(", lastNameGen='").append(lastNameGen).append("'");
        sb.append(", firstNameNom='").append(firstNameNom).append("'");
        sb.append(", homePhone='").append(homePhone).append("'");
        sb.append(", test=").append(test);
        sb.append(", videoLiveCount=").append(videoLiveCount);
        sb.append(", livejournal='").append(livejournal).append("'");
        sb.append(", isMessageRequest=").append(isMessageRequest);
        sb.append(", relatives=").append(relatives);
        sb.append(", photoMax=").append(photoMax);
        sb.append(", canSeeAudio=").append(canSeeAudio);
        sb.append(", firstNameIns='").append(firstNameIns).append("'");
        sb.append(", homeTown='").append(homeTown).append("'");
        sb.append(", lists=").append(lists);
        sb.append(", canBeInvitedGroup=").append(canBeInvitedGroup);
        sb.append(", ownerState=").append(ownerState);
        sb.append(", videoLive=").append(videoLive);
        sb.append(", photo200Orig=").append(photo200Orig);
        sb.append(", photo400Orig=").append(photo400Orig);
        sb.append(", clipsCount=").append(clipsCount);
        sb.append(", isFavorite=").append(isFavorite);
        sb.append(", exports=").append(exports);
        sb.append(", isBestFriend=").append(isBestFriend);
        sb.append(", timezone=").append(timezone);
        sb.append(", university=").append(university);
        sb.append(", canSubscribePosts=").append(canSubscribePosts);
        sb.append(", firstNameDat='").append(firstNameDat).append("'");
        sb.append(", contactId=").append(contactId);
        sb.append(", facultyName='").append(facultyName).append("'");
        sb.append(", photoMaxOrig=").append(photoMaxOrig);
        sb.append(", lastNameDat='").append(lastNameDat).append("'");
        sb.append(", mobilePhone='").append(mobilePhone).append("'");
        sb.append(", isHiddenFromFeed=").append(isHiddenFromFeed);
        sb.append(", canPost=").append(canPost);
        sb.append(", photo400='").append(photo400).append("'");
        sb.append(", maidenName='").append(maidenName).append("'");
        sb.append(", serviceDescription='").append(serviceDescription).append("'");
        sb.append(", wallComments=").append(wallComments);
        sb.append(", canBan=").append(canBan);
        sb.append(", videoLiveLevel=").append(videoLiveLevel);
        sb.append(", universityName='").append(universityName).append("'");
        sb.append(", canUploadDoc=").append(canUploadDoc);
        sb.append(", lastNameAcc='").append(lastNameAcc).append("'");
        sb.append(", canWritePrivateMessage=").append(canWritePrivateMessage);
        sb.append(", activities='").append(activities).append("'");
        sb.append(", accessKey='").append(accessKey).append("'");
        sb.append(", followersCount=").append(followersCount);
        sb.append(", facebookName='").append(facebookName).append("'");
        sb.append(", lastNameAbl='").append(lastNameAbl).append("'");
        sb.append('}');
        return sb.toString();
    }
}
