// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.video.responses;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.video.StreamInputParams;
import java.util.Objects;

/**
 * StartStreamingResponse object
 */
public class StartStreamingResponse implements Validable {
    /**
     * Video access key
     */
    @SerializedName("access_key")
    @Required
    private String accessKey;

    /**
     * Video description
     */
    @SerializedName("description")
    @Required
    private String description;

    /**
     * Video title
     */
    @SerializedName("name")
    @Required
    private String name;

    /**
     * Owner ID of created video object
     * Entity: owner
     */
    @SerializedName("owner_id")
    @Required
    private Long ownerId;

    @SerializedName("post_id")
    private Integer postId;

    @SerializedName("stream")
    @Required
    private StreamInputParams stream;

    /**
     * Video ID of created video object
     */
    @SerializedName("video_id")
    @Required
    private Integer videoId;

    public String getAccessKey() {
        return accessKey;
    }

    public StartStreamingResponse setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public StartStreamingResponse setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return name;
    }

    public StartStreamingResponse setName(String name) {
        this.name = name;
        return this;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public StartStreamingResponse setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Integer getPostId() {
        return postId;
    }

    public StartStreamingResponse setPostId(Integer postId) {
        this.postId = postId;
        return this;
    }

    public StreamInputParams getStream() {
        return stream;
    }

    public StartStreamingResponse setStream(StreamInputParams stream) {
        this.stream = stream;
        return this;
    }

    public Integer getVideoId() {
        return videoId;
    }

    public StartStreamingResponse setVideoId(Integer videoId) {
        this.videoId = videoId;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(stream, accessKey, name, description, videoId, postId, ownerId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StartStreamingResponse startStreamingResponse = (StartStreamingResponse) o;
        return Objects.equals(postId, startStreamingResponse.postId) &&
                Objects.equals(stream, startStreamingResponse.stream) &&
                Objects.equals(ownerId, startStreamingResponse.ownerId) &&
                Objects.equals(accessKey, startStreamingResponse.accessKey) &&
                Objects.equals(name, startStreamingResponse.name) &&
                Objects.equals(description, startStreamingResponse.description) &&
                Objects.equals(videoId, startStreamingResponse.videoId);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("StartStreamingResponse{");
        sb.append("postId=").append(postId);
        sb.append(", stream=").append(stream);
        sb.append(", ownerId=").append(ownerId);
        sb.append(", accessKey='").append(accessKey).append("'");
        sb.append(", name='").append(name).append("'");
        sb.append(", description='").append(description).append("'");
        sb.append(", videoId=").append(videoId);
        sb.append('}');
        return sb.toString();
    }
}
