// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.objects.wall;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.base.BoolInt;
import com.vk.api.sdk.objects.base.CommentsInfo;
import com.vk.api.sdk.objects.newsfeed.ItemWallpostFeedback;
import java.util.List;
import java.util.Objects;

/**
 * WallItem object
 */
public class WallItem extends Wallpost implements Validable {
    /**
     * Information whether current user can delete the post
     */
    @SerializedName("can_delete")
    private BoolInt canDelete;

    /**
     * Information whether current user can edit the post
     */
    @SerializedName("can_edit")
    private BoolInt canEdit;

    /**
     * Information whether current user can pin the post
     */
    @SerializedName("can_pin")
    private BoolInt canPin;

    /**
     * Index of current carousel element
     */
    @SerializedName("carousel_offset")
    private Integer carouselOffset;

    @SerializedName("comments")
    private CommentsInfo comments;

    @SerializedName("copy_history")
    private List<WallpostFull> copyHistory;

    /**
     * Post creator ID (if post still can be edited)
     * Entity: owner
     */
    @SerializedName("created_by")
    private Long createdBy;

    @SerializedName("donut")
    private WallpostDonut donut;

    @SerializedName("feedback")
    private ItemWallpostFeedback feedback;

    /**
     * Hash for sharing
     */
    @SerializedName("hash")
    private String hash;

    /**
     * Information whether the post is pinned
     */
    @SerializedName("is_pinned")
    private BoolInt isPinned;

    /**
     * Information whether the post is marked as ads
     */
    @SerializedName("marked_as_ads")
    private BoolInt markedAsAds;

    /**
     * Preview length control parameter
     */
    @SerializedName("short_text_rate")
    private Number shortTextRate;

    /**
     * Entity: owner
     */
    @SerializedName("to_id")
    private Long toId;

    /**
     * Topic ID. Allowed values can be obtained from newsfeed.getPostTopics method
     */
    @SerializedName("topic_id")
    private WallItemTopicId topicId;

    @SerializedName("type")
    private PostType type;

    public boolean canDelete() {
        return canDelete == BoolInt.YES;
    }

    public BoolInt getCanDelete() {
        return canDelete;
    }

    public boolean canEdit() {
        return canEdit == BoolInt.YES;
    }

    public BoolInt getCanEdit() {
        return canEdit;
    }

    public boolean canPin() {
        return canPin == BoolInt.YES;
    }

    public BoolInt getCanPin() {
        return canPin;
    }

    public Integer getCarouselOffset() {
        return carouselOffset;
    }

    public WallItem setCarouselOffset(Integer carouselOffset) {
        this.carouselOffset = carouselOffset;
        return this;
    }

    public CommentsInfo getComments() {
        return comments;
    }

    public WallItem setComments(CommentsInfo comments) {
        this.comments = comments;
        return this;
    }

    public List<WallpostFull> getCopyHistory() {
        return copyHistory;
    }

    public WallItem setCopyHistory(List<WallpostFull> copyHistory) {
        this.copyHistory = copyHistory;
        return this;
    }

    public Long getCreatedBy() {
        return createdBy;
    }

    public WallItem setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public WallpostDonut getDonut() {
        return donut;
    }

    public WallItem setDonut(WallpostDonut donut) {
        this.donut = donut;
        return this;
    }

    public ItemWallpostFeedback getFeedback() {
        return feedback;
    }

    public WallItem setFeedback(ItemWallpostFeedback feedback) {
        this.feedback = feedback;
        return this;
    }

    public String getHash() {
        return hash;
    }

    public WallItem setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public boolean isPinned() {
        return isPinned == BoolInt.YES;
    }

    public BoolInt getIsPinned() {
        return isPinned;
    }

    public boolean isMarkedAsAds() {
        return markedAsAds == BoolInt.YES;
    }

    public BoolInt getMarkedAsAds() {
        return markedAsAds;
    }

    public Number getShortTextRate() {
        return shortTextRate;
    }

    public WallItem setShortTextRate(Number shortTextRate) {
        this.shortTextRate = shortTextRate;
        return this;
    }

    public Long getToId() {
        return toId;
    }

    public WallItem setToId(Long toId) {
        this.toId = toId;
        return this;
    }

    public WallItemTopicId getTopicId() {
        return topicId;
    }

    public WallItem setTopicId(WallItemTopicId topicId) {
        this.topicId = topicId;
        return this;
    }

    public PostType getType() {
        return type;
    }

    public WallItem setType(PostType type) {
        this.type = type;
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(toId, carouselOffset, comments, isPinned, canEdit, shortTextRate, type, feedback, topicId, createdBy, donut, canDelete, canPin, markedAsAds, hash, copyHistory);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WallItem wallItem = (WallItem) o;
        return Objects.equals(comments, wallItem.comments) &&
                Objects.equals(canEdit, wallItem.canEdit) &&
                Objects.equals(toId, wallItem.toId) &&
                Objects.equals(type, wallItem.type) &&
                Objects.equals(createdBy, wallItem.createdBy) &&
                Objects.equals(canPin, wallItem.canPin) &&
                Objects.equals(copyHistory, wallItem.copyHistory) &&
                Objects.equals(isPinned, wallItem.isPinned) &&
                Objects.equals(feedback, wallItem.feedback) &&
                Objects.equals(shortTextRate, wallItem.shortTextRate) &&
                Objects.equals(canDelete, wallItem.canDelete) &&
                Objects.equals(donut, wallItem.donut) &&
                Objects.equals(markedAsAds, wallItem.markedAsAds) &&
                Objects.equals(topicId, wallItem.topicId) &&
                Objects.equals(carouselOffset, wallItem.carouselOffset) &&
                Objects.equals(hash, wallItem.hash);
    }

    @Override
    public String toString() {
        final Gson gson = new Gson();
        return gson.toJson(this);
    }

    public String toPrettyString() {
        final StringBuilder sb = new StringBuilder("WallItem{");
        sb.append("comments=").append(comments);
        sb.append(", canEdit=").append(canEdit);
        sb.append(", toId=").append(toId);
        sb.append(", type=").append(type);
        sb.append(", createdBy=").append(createdBy);
        sb.append(", canPin=").append(canPin);
        sb.append(", copyHistory=").append(copyHistory);
        sb.append(", isPinned=").append(isPinned);
        sb.append(", feedback=").append(feedback);
        sb.append(", shortTextRate=").append(shortTextRate);
        sb.append(", canDelete=").append(canDelete);
        sb.append(", donut=").append(donut);
        sb.append(", markedAsAds=").append(markedAsAds);
        sb.append(", topicId=").append(topicId);
        sb.append(", carouselOffset=").append(carouselOffset);
        sb.append(", hash='").append(hash).append("'");
        sb.append('}');
        return sb.toString();
    }
}
