// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.ads;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.ads.responses.CreateLookalikeRequestResponse;
import com.vk.api.sdk.objects.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Ads.createLookalikeRequest method
 */
public class AdsCreateLookalikeRequestQuery extends AbstractQueryBuilder<AdsCreateLookalikeRequestQuery, CreateLookalikeRequestResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param accountId value of "account id" parameter.
     * @param sourceType value of "source type" parameter.
     */
    public AdsCreateLookalikeRequestQuery(VkApiClient client, UserActor actor, Integer accountId,
            String sourceType) {
        super(client, "ads.createLookalikeRequest", CreateLookalikeRequestResponse.class);
        accessToken(actor.getAccessToken());
        accountId(accountId);
        sourceType(sourceType);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public AdsCreateLookalikeRequestQuery(VkApiClient client, UserActor actor) {
        super(client, "ads.createLookalikeRequest", CreateLookalikeRequestResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set account id
     *
     * @param value value of "account id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("account_id")
    public AdsCreateLookalikeRequestQuery accountId(Integer value) {
        return unsafeParam("account_id", value);
    }

    /**
     * Set client id
     *
     * @param value value of "client id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("client_id")
    public AdsCreateLookalikeRequestQuery clientId(Integer value) {
        return unsafeParam("client_id", value);
    }

    /**
     * Set source type
     *
     * @param value value of "source type" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("source_type")
    public AdsCreateLookalikeRequestQuery sourceType(String value) {
        return unsafeParam("source_type", value);
    }

    /**
     * Set retargeting group id
     *
     * @param value value of "retargeting group id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("retargeting_group_id")
    public AdsCreateLookalikeRequestQuery retargetingGroupId(Integer value) {
        return unsafeParam("retargeting_group_id", value);
    }

    @Override
    protected AdsCreateLookalikeRequestQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("account_id", "access_token", "source_type");
    }
}
