// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.ads;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.ads.responses.GetRejectionReasonResponse;
import com.vk.api.sdk.objects.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Ads.getRejectionReason method
 */
public class AdsGetRejectionReasonQuery extends AbstractQueryBuilder<AdsGetRejectionReasonQuery, GetRejectionReasonResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param accountId value of "account id" parameter.
     * @param adId value of "ad id" parameter.
     */
    public AdsGetRejectionReasonQuery(VkApiClient client, UserActor actor, Integer accountId,
            Integer adId) {
        super(client, "ads.getRejectionReason", GetRejectionReasonResponse.class);
        accessToken(actor.getAccessToken());
        accountId(accountId);
        adId(adId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public AdsGetRejectionReasonQuery(VkApiClient client, UserActor actor) {
        super(client, "ads.getRejectionReason", GetRejectionReasonResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Advertising account ID.
     *
     * @param value value of "account id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("account_id")
    public AdsGetRejectionReasonQuery accountId(Integer value) {
        return unsafeParam("account_id", value);
    }

    /**
     * Ad ID.
     *
     * @param value value of "ad id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("ad_id")
    public AdsGetRejectionReasonQuery adId(Integer value) {
        return unsafeParam("ad_id", value);
    }

    @Override
    protected AdsGetRejectionReasonQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("ad_id", "account_id", "access_token");
    }
}
