// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.ads;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.Utils;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.ads.responses.GetTargetGroupsResponse;
import com.vk.api.sdk.objects.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Ads.getTargetGroups method
 */
public class AdsGetTargetGroupsQuery extends AbstractQueryBuilder<AdsGetTargetGroupsQuery, List<GetTargetGroupsResponse>> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param accountId value of "account id" parameter.
     */
    public AdsGetTargetGroupsQuery(VkApiClient client, UserActor actor, Integer accountId) {
        super(client, "ads.getTargetGroups", Utils.buildParametrizedType(List.class, GetTargetGroupsResponse.class));
        accessToken(actor.getAccessToken());
        accountId(accountId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public AdsGetTargetGroupsQuery(VkApiClient client, UserActor actor) {
        super(client, "ads.getTargetGroups", Utils.buildParametrizedType(List.class, GetTargetGroupsResponse.class));
        accessToken(actor.getAccessToken());
    }

    /**
     * Advertising account ID.
     *
     * @param value value of "account id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("account_id")
    public AdsGetTargetGroupsQuery accountId(Integer value) {
        return unsafeParam("account_id", value);
    }

    /**
     * 'Only for advertising agencies.', ID of the client with the advertising account where the group will be created.
     *
     * @param value value of "client id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("client_id")
    public AdsGetTargetGroupsQuery clientId(Integer value) {
        return unsafeParam("client_id", value);
    }

    /**
     * '1' - to return pixel code.
     *
     * @param value value of "extended" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("extended")
    public AdsGetTargetGroupsQuery extended(Boolean value) {
        return unsafeParam("extended", value);
    }

    @Override
    protected AdsGetTargetGroupsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("account_id", "access_token");
    }
}
