// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.ads;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.ads.responses.RemoveTargetContactsResponse;
import com.vk.api.sdk.objects.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Ads.removeTargetContacts method
 */
public class AdsRemoveTargetContactsQuery extends AbstractQueryBuilder<AdsRemoveTargetContactsQuery, RemoveTargetContactsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param accountId value of "account id" parameter.
     * @param targetGroupId value of "target group id" parameter.
     * @param contacts value of "contacts" parameter.
     */
    public AdsRemoveTargetContactsQuery(VkApiClient client, UserActor actor, Integer accountId,
            Integer targetGroupId, String contacts) {
        super(client, "ads.removeTargetContacts", RemoveTargetContactsResponse.class);
        accessToken(actor.getAccessToken());
        accountId(accountId);
        targetGroupId(targetGroupId);
        contacts(contacts);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public AdsRemoveTargetContactsQuery(VkApiClient client, UserActor actor) {
        super(client, "ads.removeTargetContacts", RemoveTargetContactsResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set account id
     *
     * @param value value of "account id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("account_id")
    public AdsRemoveTargetContactsQuery accountId(Integer value) {
        return unsafeParam("account_id", value);
    }

    /**
     * Set client id
     *
     * @param value value of "client id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("client_id")
    public AdsRemoveTargetContactsQuery clientId(Integer value) {
        return unsafeParam("client_id", value);
    }

    /**
     * Set target group id
     *
     * @param value value of "target group id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("target_group_id")
    public AdsRemoveTargetContactsQuery targetGroupId(Integer value) {
        return unsafeParam("target_group_id", value);
    }

    /**
     * Set contacts
     *
     * @param value value of "contacts" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("contacts")
    public AdsRemoveTargetContactsQuery contacts(String value) {
        return unsafeParam("contacts", value);
    }

    @Override
    protected AdsRemoveTargetContactsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("contacts", "target_group_id", "account_id", "access_token");
    }
}
