// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.ads;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Ads.updateTargetGroup method
 */
public class AdsUpdateTargetGroupQuery extends AbstractQueryBuilder<AdsUpdateTargetGroupQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param accountId value of "account id" parameter.
     * @param targetGroupId value of "target group id" parameter.
     * @param name value of "name" parameter.
     * @param lifetime value of "lifetime" parameter. Maximum is 720. Minimum is 1.
     */
    public AdsUpdateTargetGroupQuery(VkApiClient client, UserActor actor, Integer accountId,
            Integer targetGroupId, String name, Integer lifetime) {
        super(client, "ads.updateTargetGroup", OkResponse.class);
        accessToken(actor.getAccessToken());
        accountId(accountId);
        targetGroupId(targetGroupId);
        name(name);
        lifetime(lifetime);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public AdsUpdateTargetGroupQuery(VkApiClient client, UserActor actor) {
        super(client, "ads.updateTargetGroup", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Advertising account ID.
     *
     * @param value value of "account id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("account_id")
    public AdsUpdateTargetGroupQuery accountId(Integer value) {
        return unsafeParam("account_id", value);
    }

    /**
     * 'Only for advertising agencies.' , ID of the client with the advertising account where the group will be created.
     *
     * @param value value of "client id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("client_id")
    public AdsUpdateTargetGroupQuery clientId(Integer value) {
        return unsafeParam("client_id", value);
    }

    /**
     * Group ID.
     *
     * @param value value of "target group id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("target_group_id")
    public AdsUpdateTargetGroupQuery targetGroupId(Integer value) {
        return unsafeParam("target_group_id", value);
    }

    /**
     * New name of the target group - a string up to 64 characters long.
     *
     * @param value value of "name" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("name")
    public AdsUpdateTargetGroupQuery name(String value) {
        return unsafeParam("name", value);
    }

    /**
     * Domain of the site where user accounting code will be placed.
     *
     * @param value value of "domain" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("domain")
    public AdsUpdateTargetGroupQuery domain(String value) {
        return unsafeParam("domain", value);
    }

    /**
     * 'Only for the groups that get audience from sites with user accounting code.', Time in days when users added to a retarget group will be automatically excluded from it. '0' - automatic exclusion is off.
     *
     * @param value value of "lifetime" parameter. Maximum is 720. Minimum is 1.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("lifetime")
    public AdsUpdateTargetGroupQuery lifetime(Integer value) {
        return unsafeParam("lifetime", value);
    }

    /**
     * Set target pixel id
     *
     * @param value value of "target pixel id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("target_pixel_id")
    public AdsUpdateTargetGroupQuery targetPixelId(Integer value) {
        return unsafeParam("target_pixel_id", value);
    }

    /**
     * Set target pixel rules
     *
     * @param value value of "target pixel rules" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("target_pixel_rules")
    public AdsUpdateTargetGroupQuery targetPixelRules(String value) {
        return unsafeParam("target_pixel_rules", value);
    }

    @Override
    protected AdsUpdateTargetGroupQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("lifetime", "target_group_id", "name", "account_id", "access_token");
    }
}
