// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.ads;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.UndefinedResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Ads.updateTargetPixel method
 */
public class AdsUpdateTargetPixelQuery extends AbstractQueryBuilder<AdsUpdateTargetPixelQuery, UndefinedResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param accountId value of "account id" parameter.
     * @param targetPixelId value of "target pixel id" parameter.
     * @param name value of "name" parameter.
     * @param categoryId value of "category id" parameter.
     */
    public AdsUpdateTargetPixelQuery(VkApiClient client, UserActor actor, Integer accountId,
            Integer targetPixelId, String name, Integer categoryId) {
        super(client, "ads.updateTargetPixel", UndefinedResponse.class);
        accessToken(actor.getAccessToken());
        accountId(accountId);
        targetPixelId(targetPixelId);
        name(name);
        categoryId(categoryId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public AdsUpdateTargetPixelQuery(VkApiClient client, UserActor actor) {
        super(client, "ads.updateTargetPixel", UndefinedResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set account id
     *
     * @param value value of "account id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("account_id")
    public AdsUpdateTargetPixelQuery accountId(Integer value) {
        return unsafeParam("account_id", value);
    }

    /**
     * Set client id
     *
     * @param value value of "client id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("client_id")
    public AdsUpdateTargetPixelQuery clientId(Integer value) {
        return unsafeParam("client_id", value);
    }

    /**
     * Set target pixel id
     *
     * @param value value of "target pixel id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("target_pixel_id")
    public AdsUpdateTargetPixelQuery targetPixelId(Integer value) {
        return unsafeParam("target_pixel_id", value);
    }

    /**
     * Set name
     *
     * @param value value of "name" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("name")
    public AdsUpdateTargetPixelQuery name(String value) {
        return unsafeParam("name", value);
    }

    /**
     * Set domain
     *
     * @param value value of "domain" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("domain")
    public AdsUpdateTargetPixelQuery domain(String value) {
        return unsafeParam("domain", value);
    }

    /**
     * Set category id
     *
     * @param value value of "category id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("category_id")
    public AdsUpdateTargetPixelQuery categoryId(Integer value) {
        return unsafeParam("category_id", value);
    }

    @Override
    protected AdsUpdateTargetPixelQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("name", "category_id", "target_pixel_id", "account_id", "access_token");
    }
}
