// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.asr;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.asr.responses.CheckStatusResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Asr.checkStatus method
 */
public class AsrCheckStatusQuery extends AbstractQueryBuilder<AsrCheckStatusQuery, CheckStatusResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param taskId value of "task id" parameter.
     */
    public AsrCheckStatusQuery(VkApiClient client, ServiceActor actor, String taskId) {
        super(client, "asr.checkStatus", CheckStatusResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        taskId(taskId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public AsrCheckStatusQuery(VkApiClient client, ServiceActor actor) {
        super(client, "asr.checkStatus", CheckStatusResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * ID of ASR task in UUID format.
     *
     * @param value value of "task id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("task_id")
    public AsrCheckStatusQuery taskId(String value) {
        return unsafeParam("task_id", value);
    }

    @Override
    protected AsrCheckStatusQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("task_id", "access_token");
    }
}
