// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.asr;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.asr.ProcessModel;
import com.vk.api.sdk.objects.asr.responses.ProcessResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Asr.process method
 */
public class AsrProcessQuery extends AbstractQueryBuilder<AsrProcessQuery, ProcessResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param audio value of "audio" parameter.
     * @param model value of "model" parameter.
     */
    public AsrProcessQuery(VkApiClient client, ServiceActor actor, String audio,
            ProcessModel model) {
        super(client, "asr.process", ProcessResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        audio(audio);
        model(model);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public AsrProcessQuery(VkApiClient client, ServiceActor actor) {
        super(client, "asr.process", ProcessResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * This parameter is a JSON response returned from [vk.com/dev/upload_files_2|file uploading server].
     *
     * @param value value of "audio" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("audio")
    public AsrProcessQuery audio(String value) {
        return unsafeParam("audio", value);
    }

    /**
     * Which model to use for recognition. `neutral` -- general purpose (interviews, TV shows, etc.), `spontaneous` -- for NSFW audios (slang, profanity, etc.)
     *
     * @param value value of "model" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("model")
    public AsrProcessQuery model(ProcessModel value) {
        return unsafeParam("model", value);
    }

    @Override
    protected AsrProcessQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("model", "audio", "access_token");
    }
}
