// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.database;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.database.responses.GetCountriesResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Database.getCountries method
 */
public class DatabaseGetCountriesQuery extends AbstractQueryBuilder<DatabaseGetCountriesQuery, GetCountriesResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public DatabaseGetCountriesQuery(VkApiClient client, UserActor actor) {
        super(client, "database.getCountries", GetCountriesResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * '1' - to return a full list of all countries, '0' - to return a list of countries near the current user's country (default).
     *
     * @param value value of "need all" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("need_all")
    public DatabaseGetCountriesQuery needAll(Boolean value) {
        return unsafeParam("need_all", value);
    }

    /**
     * Country codes in [vk.com/dev/country_codes|ISO 3166-1 alpha-2] standard.
     *
     * @param value value of "code" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("code")
    public DatabaseGetCountriesQuery code(String value) {
        return unsafeParam("code", value);
    }

    /**
     * Offset needed to return a specific subset of countries.
     *
     * @param value value of "offset" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public DatabaseGetCountriesQuery offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * Number of countries to return.
     *
     * @param value value of "count" parameter. Maximum is 1000. Minimum is 0. By default 100.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public DatabaseGetCountriesQuery count(Integer value) {
        return unsafeParam("count", value);
    }

    @Override
    protected DatabaseGetCountriesQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
