// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.docs;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.docs.responses.GetTypesResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Docs.getTypes method
 */
public class DocsGetTypesQuery extends AbstractQueryBuilder<DocsGetTypesQuery, GetTypesResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public DocsGetTypesQuery(VkApiClient client, UserActor actor) {
        super(client, "docs.getTypes", GetTypesResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of the user or community that owns the documents. Use a negative value to designate a community ID.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public DocsGetTypesQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    @Override
    protected DocsGetTypesQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
