// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.fave;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.BoolResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Fave.removeArticle method
 */
public class FaveRemoveArticleQuery extends AbstractQueryBuilder<FaveRemoveArticleQuery, BoolResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     * @param articleId value of "article id" parameter. Minimum is 0.
     */
    public FaveRemoveArticleQuery(VkApiClient client, UserActor actor, Long ownerId,
            Integer articleId) {
        super(client, "fave.removeArticle", BoolResponse.class);
        accessToken(actor.getAccessToken());
        ownerId(ownerId);
        articleId(articleId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public FaveRemoveArticleQuery(VkApiClient client, UserActor actor) {
        super(client, "fave.removeArticle", BoolResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set owner id
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public FaveRemoveArticleQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Set article id
     *
     * @param value value of "article id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("article_id")
    public FaveRemoveArticleQuery articleId(Integer value) {
        return unsafeParam("article_id", value);
    }

    @Override
    protected FaveRemoveArticleQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("owner_id", "article_id", "access_token");
    }
}
