// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.friends;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Friends.deleteList method
 */
public class FriendsDeleteListQuery extends AbstractQueryBuilder<FriendsDeleteListQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param listId value of "list id" parameter. Maximum is 24. Minimum is 0.
     */
    public FriendsDeleteListQuery(VkApiClient client, UserActor actor, Integer listId) {
        super(client, "friends.deleteList", OkResponse.class);
        accessToken(actor.getAccessToken());
        listId(listId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public FriendsDeleteListQuery(VkApiClient client, UserActor actor) {
        super(client, "friends.deleteList", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of the friend list to delete.
     *
     * @param value value of "list id" parameter. Maximum is 24. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("list_id")
    public FriendsDeleteListQuery listId(Integer value) {
        return unsafeParam("list_id", value);
    }

    @Override
    protected FriendsDeleteListQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("list_id", "access_token");
    }
}
