// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.groups;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.groups.AddAddressWorkInfoStatus;
import com.vk.api.sdk.objects.groups.responses.AddAddressResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Groups.addAddress method
 */
public class GroupsAddAddressQuery extends AbstractQueryBuilder<GroupsAddAddressQuery, AddAddressResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @param title value of "title" parameter.
     * @param address value of "address" parameter.
     * @param cityId value of "city id" parameter. Minimum is 1.
     * @param latitude value of "latitude" parameter. Maximum is 90. Minimum is -90.
     * @param longitude value of "longitude" parameter. Maximum is 180. Minimum is -180.
     */
    public GroupsAddAddressQuery(VkApiClient client, GroupActor actor, Long groupId, String title,
            String address, Integer cityId, Number latitude, Number longitude) {
        super(client, "groups.addAddress", AddAddressResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
        groupId(groupId);
        title(title);
        address(address);
        cityId(cityId);
        latitude(latitude);
        longitude(longitude);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsAddAddressQuery(VkApiClient client, GroupActor actor) {
        super(client, "groups.addAddress", AddAddressResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @param title value of "title" parameter.
     * @param address value of "address" parameter.
     * @param cityId value of "city id" parameter. Minimum is 1.
     * @param latitude value of "latitude" parameter. Maximum is 90. Minimum is -90.
     * @param longitude value of "longitude" parameter. Maximum is 180. Minimum is -180.
     */
    public GroupsAddAddressQuery(VkApiClient client, UserActor actor, Long groupId, String title,
            String address, Integer cityId, Number latitude, Number longitude) {
        super(client, "groups.addAddress", AddAddressResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
        title(title);
        address(address);
        cityId(cityId);
        latitude(latitude);
        longitude(longitude);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsAddAddressQuery(VkApiClient client, UserActor actor) {
        super(client, "groups.addAddress", AddAddressResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set group id
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public GroupsAddAddressQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set title
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public GroupsAddAddressQuery title(String value) {
        return unsafeParam("title", value);
    }

    /**
     * Set address
     *
     * @param value value of "address" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("address")
    public GroupsAddAddressQuery address(String value) {
        return unsafeParam("address", value);
    }

    /**
     * Set additional address
     *
     * @param value value of "additional address" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("additional_address")
    public GroupsAddAddressQuery additionalAddress(String value) {
        return unsafeParam("additional_address", value);
    }

    /**
     * Set city id
     *
     * @param value value of "city id" parameter. Minimum is 1.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("city_id")
    public GroupsAddAddressQuery cityId(Integer value) {
        return unsafeParam("city_id", value);
    }

    /**
     * Set metro id
     *
     * @param value value of "metro id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("metro_id")
    public GroupsAddAddressQuery metroId(Integer value) {
        return unsafeParam("metro_id", value);
    }

    /**
     * Set latitude
     *
     * @param value value of "latitude" parameter. Maximum is 90. Minimum is -90.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("latitude")
    public GroupsAddAddressQuery latitude(Number value) {
        return unsafeParam("latitude", value);
    }

    /**
     * Set longitude
     *
     * @param value value of "longitude" parameter. Maximum is 180. Minimum is -180.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("longitude")
    public GroupsAddAddressQuery longitude(Number value) {
        return unsafeParam("longitude", value);
    }

    /**
     * Set phone
     *
     * @param value value of "phone" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("phone")
    public GroupsAddAddressQuery phone(String value) {
        return unsafeParam("phone", value);
    }

    /**
     * Set work info status
     *
     * @param value value of "work info status" parameter. By default no_information.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("work_info_status")
    public GroupsAddAddressQuery workInfoStatus(AddAddressWorkInfoStatus value) {
        return unsafeParam("work_info_status", value);
    }

    /**
     * Set timetable
     *
     * @param value value of "timetable" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("timetable")
    public GroupsAddAddressQuery timetable(String value) {
        return unsafeParam("timetable", value);
    }

    /**
     * Set is main address
     *
     * @param value value of "is main address" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("is_main_address")
    public GroupsAddAddressQuery isMainAddress(Boolean value) {
        return unsafeParam("is_main_address", value);
    }

    @Override
    protected GroupsAddAddressQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("address", "group_id", "city_id", "longitude", "title", "latitude", "access_token");
    }
}
