// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.groups;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.groups.Fields;
import com.vk.api.sdk.objects.groups.responses.GetByIdObjectResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Groups.getById method
 */
public class GroupsGetByIdQueryWithObject extends AbstractQueryBuilder<GroupsGetByIdQueryWithObject, GetByIdObjectResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetByIdQueryWithObject(VkApiClient client, GroupActor actor) {
        super(client, "groups.getById", GetByIdObjectResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetByIdQueryWithObject(VkApiClient client, UserActor actor) {
        super(client, "groups.getById", GetByIdObjectResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetByIdQueryWithObject(VkApiClient client, ServiceActor actor) {
        super(client, "groups.getById", GetByIdObjectResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
    }

    /**
     * ID or screen name of the community.
     *
     * @param value value of "group id" parameter. Entity - groups
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public GroupsGetByIdQueryWithObject groupId(String value) {
        return unsafeParam("group_id", value);
    }

    /**
     * groupIds
     * IDs or screen names of communities.
     *
     * @param value value of "group ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_ids")
    public GroupsGetByIdQueryWithObject groupIds(String... value) {
        return unsafeParam("group_ids", value);
    }

    /**
     * IDs or screen names of communities.
     *
     * @param value value of "group ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_ids")
    public GroupsGetByIdQueryWithObject groupIds(List<String> value) {
        return unsafeParam("group_ids", value);
    }

    /**
     * fields
     * Group fields to return.
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fields")
    public GroupsGetByIdQueryWithObject fields(Fields... value) {
        return unsafeParam("fields", value);
    }

    /**
     * Group fields to return.
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fields")
    public GroupsGetByIdQueryWithObject fields(List<Fields> value) {
        return unsafeParam("fields", value);
    }

    @Override
    protected GroupsGetByIdQueryWithObject getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
