// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.groups;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.groups.responses.GetCallbackServersResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Groups.getCallbackServers method
 */
public class GroupsGetCallbackServersQuery extends AbstractQueryBuilder<GroupsGetCallbackServersQuery, GetCallbackServersResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     */
    public GroupsGetCallbackServersQuery(VkApiClient client, GroupActor actor, Long groupId) {
        super(client, "groups.getCallbackServers", GetCallbackServersResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
        groupId(groupId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetCallbackServersQuery(VkApiClient client, GroupActor actor) {
        super(client, "groups.getCallbackServers", GetCallbackServersResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     */
    public GroupsGetCallbackServersQuery(VkApiClient client, UserActor actor, Long groupId) {
        super(client, "groups.getCallbackServers", GetCallbackServersResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetCallbackServersQuery(VkApiClient client, UserActor actor) {
        super(client, "groups.getCallbackServers", GetCallbackServersResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set group id
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public GroupsGetCallbackServersQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * serverIds
     * Set server ids
     *
     * @param value value of "server ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("server_ids")
    public GroupsGetCallbackServersQuery serverIds(Integer... value) {
        return unsafeParam("server_ids", value);
    }

    /**
     * Set server ids
     *
     * @param value value of "server ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("server_ids")
    public GroupsGetCallbackServersQuery serverIds(List<Integer> value) {
        return unsafeParam("server_ids", value);
    }

    @Override
    protected GroupsGetCallbackServersQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "access_token");
    }
}
