// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.groups;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.groups.GetMembersFilter;
import com.vk.api.sdk.objects.groups.GetMembersSort;
import com.vk.api.sdk.objects.groups.responses.GetMembersFilterResponse;
import com.vk.api.sdk.objects.users.Fields;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Groups.getMembers method
 */
public class GroupsGetMembersQueryWithFilter extends AbstractQueryBuilder<GroupsGetMembersQueryWithFilter, GetMembersFilterResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetMembersQueryWithFilter(VkApiClient client, GroupActor actor,
            GetMembersFilter filter) {
        super(client, "groups.getMembers", GetMembersFilterResponse.class);
        accessToken(actor.getAccessToken());
        filter(filter);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetMembersQueryWithFilter(VkApiClient client, UserActor actor,
            GetMembersFilter filter) {
        super(client, "groups.getMembers", GetMembersFilterResponse.class);
        accessToken(actor.getAccessToken());
        filter(filter);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetMembersQueryWithFilter(VkApiClient client, ServiceActor actor,
            GetMembersFilter filter) {
        super(client, "groups.getMembers", GetMembersFilterResponse.class);
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        filter(filter);
    }

    /**
     * ID or screen name of the community.
     *
     * @param value value of "group id" parameter. Entity - groups
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public GroupsGetMembersQueryWithFilter groupId(String value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Sort order. Available values: 'id_asc', 'id_desc', 'time_asc', 'time_desc'. 'time_asc' and 'time_desc' are availavle only if the method is called by the group's 'moderator'.
     *
     * @param value value of "sort" parameter. By default id_asc.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("sort")
    public GroupsGetMembersQueryWithFilter sort(GetMembersSort value) {
        return unsafeParam("sort", value);
    }

    /**
     * Offset needed to return a specific subset of community members.
     *
     * @param value value of "offset" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public GroupsGetMembersQueryWithFilter offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * Number of community members to return.
     *
     * @param value value of "count" parameter. Minimum is 0. By default 1000.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public GroupsGetMembersQueryWithFilter count(Integer value) {
        return unsafeParam("count", value);
    }

    /**
     * *'friends' - only friends in this community will be returned,, *'unsure' - only those who pressed 'I may attend' will be returned (if it's an event).
     *
     * @param value value of "filter" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("filter")
    protected GroupsGetMembersQueryWithFilter filter(GetMembersFilter value) {
        return unsafeParam("filter", value);
    }

    /**
     * fields
     * List of additional fields to be returned. Available values: 'sex, bdate, city, country, photo_50, photo_100, photo_200_orig, photo_200, photo_400_orig, photo_max, photo_max_orig, online, online_mobile, lists, domain, has_mobile, contacts, connections, site, education, universities, schools, can_post, can_see_all_posts, can_see_audio, can_write_private_message, status, last_seen, common_count, relation, relatives, counters'.
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fields")
    public GroupsGetMembersQueryWithFilter fields(Fields... value) {
        return unsafeParam("fields", value);
    }

    /**
     * List of additional fields to be returned. Available values: 'sex, bdate, city, country, photo_50, photo_100, photo_200_orig, photo_200, photo_400_orig, photo_max, photo_max_orig, online, online_mobile, lists, domain, has_mobile, contacts, connections, site, education, universities, schools, can_post, can_see_all_posts, can_see_audio, can_write_private_message, status, last_seen, common_count, relation, relatives, counters'.
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fields")
    public GroupsGetMembersQueryWithFilter fields(List<Fields> value) {
        return unsafeParam("fields", value);
    }

    @Override
    protected GroupsGetMembersQueryWithFilter getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
