// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.groups;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.groups.responses.GetSettingsResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Groups.getSettings method
 */
public class GroupsGetSettingsQuery extends AbstractQueryBuilder<GroupsGetSettingsQuery, GetSettingsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Entity - groups
     *
     */
    public GroupsGetSettingsQuery(VkApiClient client, UserActor actor, String groupId) {
        super(client, "groups.getSettings", GetSettingsResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsGetSettingsQuery(VkApiClient client, UserActor actor) {
        super(client, "groups.getSettings", GetSettingsResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Community ID.
     *
     * @param value value of "group id" parameter. Entity - groups
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public GroupsGetSettingsQuery groupId(String value) {
        return unsafeParam("group_id", value);
    }

    @Override
    protected GroupsGetSettingsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "access_token");
    }
}
