// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.groups;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.groups.responses.InviteUserIdsListResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Groups.invite method
 */
public class GroupsInviteQueryWithUserIdsList extends AbstractQueryBuilder<GroupsInviteQueryWithUserIdsList, InviteUserIdsListResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     */
    public GroupsInviteQueryWithUserIdsList(VkApiClient client, UserActor actor, Long groupId,
            Long... userIdsList) {
        super(client, "groups.invite", InviteUserIdsListResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
        userIdsList(userIdsList);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     */
    public GroupsInviteQueryWithUserIdsList(VkApiClient client, UserActor actor, Long groupId,
            List<Long> userIdsList) {
        super(client, "groups.invite", InviteUserIdsListResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
        userIdsList(userIdsList);
    }

    /**
     * Community ID.
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public GroupsInviteQueryWithUserIdsList groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * User ID.
     *
     * @param value value of "user id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public GroupsInviteQueryWithUserIdsList userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * userIdsList
     * User IDs.
     *
     * @param value value of "user ids list" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_ids_list")
    protected GroupsInviteQueryWithUserIdsList userIdsList(Long... value) {
        return unsafeParam("user_ids_list", value);
    }

    /**
     * User IDs.
     *
     * @param value value of "user ids list" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_ids_list")
    protected GroupsInviteQueryWithUserIdsList userIdsList(List<Long> value) {
        return unsafeParam("user_ids_list", value);
    }

    @Override
    protected GroupsInviteQueryWithUserIdsList getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "access_token");
    }
}
