// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.groups;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.Utils;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.ServiceActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.groups.responses.IsMemberUserIdsResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Groups.isMember method
 */
public class GroupsIsMemberQueryWithUserIds extends AbstractQueryBuilder<GroupsIsMemberQueryWithUserIds, List<IsMemberUserIdsResponse>> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Entity - groups
     *
     */
    public GroupsIsMemberQueryWithUserIds(VkApiClient client, GroupActor actor, String groupId,
            Long... userIds) {
        super(client, "groups.isMember", Utils.buildParametrizedType(List.class, IsMemberUserIdsResponse.class));
        accessToken(actor.getAccessToken());
        groupId(groupId);
        userIds(userIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Entity - groups
     *
     */
    public GroupsIsMemberQueryWithUserIds(VkApiClient client, GroupActor actor, String groupId,
            List<Long> userIds) {
        super(client, "groups.isMember", Utils.buildParametrizedType(List.class, IsMemberUserIdsResponse.class));
        accessToken(actor.getAccessToken());
        groupId(groupId);
        userIds(userIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Entity - groups
     *
     */
    public GroupsIsMemberQueryWithUserIds(VkApiClient client, UserActor actor, String groupId,
            Long... userIds) {
        super(client, "groups.isMember", Utils.buildParametrizedType(List.class, IsMemberUserIdsResponse.class));
        accessToken(actor.getAccessToken());
        groupId(groupId);
        userIds(userIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Entity - groups
     *
     */
    public GroupsIsMemberQueryWithUserIds(VkApiClient client, UserActor actor, String groupId,
            List<Long> userIds) {
        super(client, "groups.isMember", Utils.buildParametrizedType(List.class, IsMemberUserIdsResponse.class));
        accessToken(actor.getAccessToken());
        groupId(groupId);
        userIds(userIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Entity - groups
     *
     */
    public GroupsIsMemberQueryWithUserIds(VkApiClient client, ServiceActor actor, String groupId,
            Long... userIds) {
        super(client, "groups.isMember", Utils.buildParametrizedType(List.class, IsMemberUserIdsResponse.class));
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        groupId(groupId);
        userIds(userIds);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build service api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Entity - groups
     *
     */
    public GroupsIsMemberQueryWithUserIds(VkApiClient client, ServiceActor actor, String groupId,
            List<Long> userIds) {
        super(client, "groups.isMember", Utils.buildParametrizedType(List.class, IsMemberUserIdsResponse.class));
        accessToken(actor.getAccessToken());
        clientSecret(actor.getClientSecret());
        groupId(groupId);
        userIds(userIds);
    }

    /**
     * ID or screen name of the community.
     *
     * @param value value of "group id" parameter. Entity - groups
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public GroupsIsMemberQueryWithUserIds groupId(String value) {
        return unsafeParam("group_id", value);
    }

    /**
     * User ID.
     *
     * @param value value of "user id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public GroupsIsMemberQueryWithUserIds userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * '1' - to return an extended response with additional fields. By default: '0'.
     *
     * @param value value of "extended" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("extended")
    public GroupsIsMemberQueryWithUserIds extended(Boolean value) {
        return unsafeParam("extended", value);
    }

    /**
     * userIds
     * User IDs.
     *
     * @param value value of "user ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_ids")
    protected GroupsIsMemberQueryWithUserIds userIds(Long... value) {
        return unsafeParam("user_ids", value);
    }

    /**
     * User IDs.
     *
     * @param value value of "user ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_ids")
    protected GroupsIsMemberQueryWithUserIds userIds(List<Long> value) {
        return unsafeParam("user_ids", value);
    }

    @Override
    protected GroupsIsMemberQueryWithUserIds getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "access_token");
    }
}
