// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.groups;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Groups.setCallbackSettings method
 */
public class GroupsSetCallbackSettingsQuery extends AbstractQueryBuilder<GroupsSetCallbackSettingsQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     */
    public GroupsSetCallbackSettingsQuery(VkApiClient client, GroupActor actor, Long groupId) {
        super(client, "groups.setCallbackSettings", OkResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
        groupId(groupId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsSetCallbackSettingsQuery(VkApiClient client, GroupActor actor) {
        super(client, "groups.setCallbackSettings", OkResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     */
    public GroupsSetCallbackSettingsQuery(VkApiClient client, UserActor actor, Long groupId) {
        super(client, "groups.setCallbackSettings", OkResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public GroupsSetCallbackSettingsQuery(VkApiClient client, UserActor actor) {
        super(client, "groups.setCallbackSettings", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Community ID.
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public GroupsSetCallbackSettingsQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Server ID.
     *
     * @param value value of "server id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("server_id")
    public GroupsSetCallbackSettingsQuery serverId(Integer value) {
        return unsafeParam("server_id", value);
    }

    /**
     * Set api version
     *
     * @param value value of "api version" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("api_version")
    public GroupsSetCallbackSettingsQuery apiVersion(String value) {
        return unsafeParam("api_version", value);
    }

    /**
     * A new incoming message has been received ('0' - disabled, '1' - enabled).
     *
     * @param value value of "message new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_new")
    public GroupsSetCallbackSettingsQuery messageNew(Boolean value) {
        return unsafeParam("message_new", value);
    }

    /**
     * A new outcoming message has been received ('0' - disabled, '1' - enabled).
     *
     * @param value value of "message reply" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_reply")
    public GroupsSetCallbackSettingsQuery messageReply(Boolean value) {
        return unsafeParam("message_reply", value);
    }

    /**
     * Allowed messages notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "message allow" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_allow")
    public GroupsSetCallbackSettingsQuery messageAllow(Boolean value) {
        return unsafeParam("message_allow", value);
    }

    /**
     * Set message edit
     *
     * @param value value of "message edit" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_edit")
    public GroupsSetCallbackSettingsQuery messageEdit(Boolean value) {
        return unsafeParam("message_edit", value);
    }

    /**
     * Denied messages notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "message deny" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_deny")
    public GroupsSetCallbackSettingsQuery messageDeny(Boolean value) {
        return unsafeParam("message_deny", value);
    }

    /**
     * Set message typing state
     *
     * @param value value of "message typing state" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_typing_state")
    public GroupsSetCallbackSettingsQuery messageTypingState(Boolean value) {
        return unsafeParam("message_typing_state", value);
    }

    /**
     * Messages read notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "message read" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_read")
    public GroupsSetCallbackSettingsQuery messageRead(Boolean value) {
        return unsafeParam("message_read", value);
    }

    /**
     * New photos notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "photo new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_new")
    public GroupsSetCallbackSettingsQuery photoNew(Boolean value) {
        return unsafeParam("photo_new", value);
    }

    /**
     * New audios notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "audio new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("audio_new")
    public GroupsSetCallbackSettingsQuery audioNew(Boolean value) {
        return unsafeParam("audio_new", value);
    }

    /**
     * New videos notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "video new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("video_new")
    public GroupsSetCallbackSettingsQuery videoNew(Boolean value) {
        return unsafeParam("video_new", value);
    }

    /**
     * New wall replies notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "wall reply new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("wall_reply_new")
    public GroupsSetCallbackSettingsQuery wallReplyNew(Boolean value) {
        return unsafeParam("wall_reply_new", value);
    }

    /**
     * Wall replies edited notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "wall reply edit" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("wall_reply_edit")
    public GroupsSetCallbackSettingsQuery wallReplyEdit(Boolean value) {
        return unsafeParam("wall_reply_edit", value);
    }

    /**
     * A wall comment has been deleted ('0' - disabled, '1' - enabled).
     *
     * @param value value of "wall reply delete" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("wall_reply_delete")
    public GroupsSetCallbackSettingsQuery wallReplyDelete(Boolean value) {
        return unsafeParam("wall_reply_delete", value);
    }

    /**
     * A wall comment has been restored ('0' - disabled, '1' - enabled).
     *
     * @param value value of "wall reply restore" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("wall_reply_restore")
    public GroupsSetCallbackSettingsQuery wallReplyRestore(Boolean value) {
        return unsafeParam("wall_reply_restore", value);
    }

    /**
     * New wall posts notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "wall post new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("wall_post_new")
    public GroupsSetCallbackSettingsQuery wallPostNew(Boolean value) {
        return unsafeParam("wall_post_new", value);
    }

    /**
     * New wall posts notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "wall repost" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("wall_repost")
    public GroupsSetCallbackSettingsQuery wallRepost(Boolean value) {
        return unsafeParam("wall_repost", value);
    }

    /**
     * New board posts notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "board post new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("board_post_new")
    public GroupsSetCallbackSettingsQuery boardPostNew(Boolean value) {
        return unsafeParam("board_post_new", value);
    }

    /**
     * Board posts edited notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "board post edit" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("board_post_edit")
    public GroupsSetCallbackSettingsQuery boardPostEdit(Boolean value) {
        return unsafeParam("board_post_edit", value);
    }

    /**
     * Board posts restored notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "board post restore" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("board_post_restore")
    public GroupsSetCallbackSettingsQuery boardPostRestore(Boolean value) {
        return unsafeParam("board_post_restore", value);
    }

    /**
     * Board posts deleted notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "board post delete" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("board_post_delete")
    public GroupsSetCallbackSettingsQuery boardPostDelete(Boolean value) {
        return unsafeParam("board_post_delete", value);
    }

    /**
     * New comment to photo notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "photo comment new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_comment_new")
    public GroupsSetCallbackSettingsQuery photoCommentNew(Boolean value) {
        return unsafeParam("photo_comment_new", value);
    }

    /**
     * A photo comment has been edited ('0' - disabled, '1' - enabled).
     *
     * @param value value of "photo comment edit" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_comment_edit")
    public GroupsSetCallbackSettingsQuery photoCommentEdit(Boolean value) {
        return unsafeParam("photo_comment_edit", value);
    }

    /**
     * A photo comment has been deleted ('0' - disabled, '1' - enabled).
     *
     * @param value value of "photo comment delete" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_comment_delete")
    public GroupsSetCallbackSettingsQuery photoCommentDelete(Boolean value) {
        return unsafeParam("photo_comment_delete", value);
    }

    /**
     * A photo comment has been restored ('0' - disabled, '1' - enabled).
     *
     * @param value value of "photo comment restore" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_comment_restore")
    public GroupsSetCallbackSettingsQuery photoCommentRestore(Boolean value) {
        return unsafeParam("photo_comment_restore", value);
    }

    /**
     * New comment to video notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "video comment new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("video_comment_new")
    public GroupsSetCallbackSettingsQuery videoCommentNew(Boolean value) {
        return unsafeParam("video_comment_new", value);
    }

    /**
     * A video comment has been edited ('0' - disabled, '1' - enabled).
     *
     * @param value value of "video comment edit" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("video_comment_edit")
    public GroupsSetCallbackSettingsQuery videoCommentEdit(Boolean value) {
        return unsafeParam("video_comment_edit", value);
    }

    /**
     * A video comment has been deleted ('0' - disabled, '1' - enabled).
     *
     * @param value value of "video comment delete" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("video_comment_delete")
    public GroupsSetCallbackSettingsQuery videoCommentDelete(Boolean value) {
        return unsafeParam("video_comment_delete", value);
    }

    /**
     * A video comment has been restored ('0' - disabled, '1' - enabled).
     *
     * @param value value of "video comment restore" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("video_comment_restore")
    public GroupsSetCallbackSettingsQuery videoCommentRestore(Boolean value) {
        return unsafeParam("video_comment_restore", value);
    }

    /**
     * New comment to market item notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "market comment new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("market_comment_new")
    public GroupsSetCallbackSettingsQuery marketCommentNew(Boolean value) {
        return unsafeParam("market_comment_new", value);
    }

    /**
     * A market comment has been edited ('0' - disabled, '1' - enabled).
     *
     * @param value value of "market comment edit" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("market_comment_edit")
    public GroupsSetCallbackSettingsQuery marketCommentEdit(Boolean value) {
        return unsafeParam("market_comment_edit", value);
    }

    /**
     * A market comment has been deleted ('0' - disabled, '1' - enabled).
     *
     * @param value value of "market comment delete" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("market_comment_delete")
    public GroupsSetCallbackSettingsQuery marketCommentDelete(Boolean value) {
        return unsafeParam("market_comment_delete", value);
    }

    /**
     * A market comment has been restored ('0' - disabled, '1' - enabled).
     *
     * @param value value of "market comment restore" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("market_comment_restore")
    public GroupsSetCallbackSettingsQuery marketCommentRestore(Boolean value) {
        return unsafeParam("market_comment_restore", value);
    }

    /**
     * Set market order new
     *
     * @param value value of "market order new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("market_order_new")
    public GroupsSetCallbackSettingsQuery marketOrderNew(Boolean value) {
        return unsafeParam("market_order_new", value);
    }

    /**
     * Set market order edit
     *
     * @param value value of "market order edit" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("market_order_edit")
    public GroupsSetCallbackSettingsQuery marketOrderEdit(Boolean value) {
        return unsafeParam("market_order_edit", value);
    }

    /**
     * A vote in a public poll has been added ('0' - disabled, '1' - enabled).
     *
     * @param value value of "poll vote new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("poll_vote_new")
    public GroupsSetCallbackSettingsQuery pollVoteNew(Boolean value) {
        return unsafeParam("poll_vote_new", value);
    }

    /**
     * Joined community notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "group join" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_join")
    public GroupsSetCallbackSettingsQuery groupJoin(Boolean value) {
        return unsafeParam("group_join", value);
    }

    /**
     * Left community notifications ('0' - disabled, '1' - enabled).
     *
     * @param value value of "group leave" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_leave")
    public GroupsSetCallbackSettingsQuery groupLeave(Boolean value) {
        return unsafeParam("group_leave", value);
    }

    /**
     * Set group change settings
     *
     * @param value value of "group change settings" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_change_settings")
    public GroupsSetCallbackSettingsQuery groupChangeSettings(Boolean value) {
        return unsafeParam("group_change_settings", value);
    }

    /**
     * Set group change photo
     *
     * @param value value of "group change photo" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_change_photo")
    public GroupsSetCallbackSettingsQuery groupChangePhoto(Boolean value) {
        return unsafeParam("group_change_photo", value);
    }

    /**
     * Set group officers edit
     *
     * @param value value of "group officers edit" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_officers_edit")
    public GroupsSetCallbackSettingsQuery groupOfficersEdit(Boolean value) {
        return unsafeParam("group_officers_edit", value);
    }

    /**
     * User added to community blacklist
     *
     * @param value value of "user block" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_block")
    public GroupsSetCallbackSettingsQuery userBlock(Boolean value) {
        return unsafeParam("user_block", value);
    }

    /**
     * User removed from community blacklist
     *
     * @param value value of "user unblock" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_unblock")
    public GroupsSetCallbackSettingsQuery userUnblock(Boolean value) {
        return unsafeParam("user_unblock", value);
    }

    /**
     * New form in lead forms
     *
     * @param value value of "lead forms new" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("lead_forms_new")
    public GroupsSetCallbackSettingsQuery leadFormsNew(Boolean value) {
        return unsafeParam("lead_forms_new", value);
    }

    /**
     * Set like add
     *
     * @param value value of "like add" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("like_add")
    public GroupsSetCallbackSettingsQuery likeAdd(Boolean value) {
        return unsafeParam("like_add", value);
    }

    /**
     * Set like remove
     *
     * @param value value of "like remove" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("like_remove")
    public GroupsSetCallbackSettingsQuery likeRemove(Boolean value) {
        return unsafeParam("like_remove", value);
    }

    /**
     * Set message event
     *
     * @param value value of "message event" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_event")
    public GroupsSetCallbackSettingsQuery messageEvent(Boolean value) {
        return unsafeParam("message_event", value);
    }

    /**
     * Set message reaction event
     *
     * @param value value of "message reaction event" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_reaction_event")
    public GroupsSetCallbackSettingsQuery messageReactionEvent(Boolean value) {
        return unsafeParam("message_reaction_event", value);
    }

    /**
     * Set donut subscription create
     *
     * @param value value of "donut subscription create" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("donut_subscription_create")
    public GroupsSetCallbackSettingsQuery donutSubscriptionCreate(Boolean value) {
        return unsafeParam("donut_subscription_create", value);
    }

    /**
     * Set donut subscription prolonged
     *
     * @param value value of "donut subscription prolonged" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("donut_subscription_prolonged")
    public GroupsSetCallbackSettingsQuery donutSubscriptionProlonged(Boolean value) {
        return unsafeParam("donut_subscription_prolonged", value);
    }

    /**
     * Set donut subscription cancelled
     *
     * @param value value of "donut subscription cancelled" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("donut_subscription_cancelled")
    public GroupsSetCallbackSettingsQuery donutSubscriptionCancelled(Boolean value) {
        return unsafeParam("donut_subscription_cancelled", value);
    }

    /**
     * Set donut subscription price changed
     *
     * @param value value of "donut subscription price changed" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("donut_subscription_price_changed")
    public GroupsSetCallbackSettingsQuery donutSubscriptionPriceChanged(Boolean value) {
        return unsafeParam("donut_subscription_price_changed", value);
    }

    /**
     * Set donut subscription expired
     *
     * @param value value of "donut subscription expired" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("donut_subscription_expired")
    public GroupsSetCallbackSettingsQuery donutSubscriptionExpired(Boolean value) {
        return unsafeParam("donut_subscription_expired", value);
    }

    /**
     * Set donut money withdraw
     *
     * @param value value of "donut money withdraw" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("donut_money_withdraw")
    public GroupsSetCallbackSettingsQuery donutMoneyWithdraw(Boolean value) {
        return unsafeParam("donut_money_withdraw", value);
    }

    /**
     * Set donut money withdraw error
     *
     * @param value value of "donut money withdraw error" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("donut_money_withdraw_error")
    public GroupsSetCallbackSettingsQuery donutMoneyWithdrawError(Boolean value) {
        return unsafeParam("donut_money_withdraw_error", value);
    }

    @Override
    protected GroupsSetCallbackSettingsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "access_token");
    }
}
