// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.leadforms;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.leadforms.responses.GetLeadsResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for LeadForms.getLeads method
 */
public class LeadFormsGetLeadsQuery extends AbstractQueryBuilder<LeadFormsGetLeadsQuery, GetLeadsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @param formId value of "form id" parameter.
     */
    public LeadFormsGetLeadsQuery(VkApiClient client, UserActor actor, Long groupId,
            Integer formId) {
        super(client, "leadForms.getLeads", GetLeadsResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
        formId(formId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public LeadFormsGetLeadsQuery(VkApiClient client, UserActor actor) {
        super(client, "leadForms.getLeads", GetLeadsResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set group id
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public LeadFormsGetLeadsQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set form id
     *
     * @param value value of "form id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("form_id")
    public LeadFormsGetLeadsQuery formId(Integer value) {
        return unsafeParam("form_id", value);
    }

    /**
     * Set limit
     *
     * @param value value of "limit" parameter. Maximum is 1000. Minimum is 1. By default 10.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("limit")
    public LeadFormsGetLeadsQuery limit(Integer value) {
        return unsafeParam("limit", value);
    }

    /**
     * Set next page token
     *
     * @param value value of "next page token" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("next_page_token")
    public LeadFormsGetLeadsQuery nextPageToken(String value) {
        return unsafeParam("next_page_token", value);
    }

    @Override
    protected LeadFormsGetLeadsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "form_id", "access_token");
    }
}
