// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.market.responses.AddPropertyResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.addProperty method
 */
public class MarketAddPropertyQuery extends AbstractQueryBuilder<MarketAddPropertyQuery, AddPropertyResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @param title value of "title" parameter.
     */
    public MarketAddPropertyQuery(VkApiClient client, UserActor actor, Long groupId, String title) {
        super(client, "market.addProperty", AddPropertyResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
        title(title);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketAddPropertyQuery(VkApiClient client, UserActor actor) {
        super(client, "market.addProperty", AddPropertyResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Group id.
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MarketAddPropertyQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Property name.
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public MarketAddPropertyQuery title(String value) {
        return unsafeParam("title", value);
    }

    @Override
    protected MarketAddPropertyQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "title", "access_token");
    }
}
