// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.market.responses.AddPropertyVariantResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.addPropertyVariant method
 */
public class MarketAddPropertyVariantQuery extends AbstractQueryBuilder<MarketAddPropertyVariantQuery, AddPropertyVariantResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @param propertyId value of "property id" parameter. Minimum is 0.
     * @param title value of "title" parameter.
     */
    public MarketAddPropertyVariantQuery(VkApiClient client, UserActor actor, Long groupId,
            Integer propertyId, String title) {
        super(client, "market.addPropertyVariant", AddPropertyVariantResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
        propertyId(propertyId);
        title(title);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketAddPropertyVariantQuery(VkApiClient client, UserActor actor) {
        super(client, "market.addPropertyVariant", AddPropertyVariantResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Group id.
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MarketAddPropertyVariantQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Property id.
     *
     * @param value value of "property id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("property_id")
    public MarketAddPropertyVariantQuery propertyId(Integer value) {
        return unsafeParam("property_id", value);
    }

    /**
     * Variant name.
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public MarketAddPropertyVariantQuery title(String value) {
        return unsafeParam("title", value);
    }

    @Override
    protected MarketAddPropertyVariantQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "title", "property_id", "access_token");
    }
}
