// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.editAlbum method
 */
public class MarketEditAlbumQuery extends AbstractQueryBuilder<MarketEditAlbumQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     * @param albumId value of "album id" parameter. Minimum is 0.
     * @param title value of "title" parameter.
     */
    public MarketEditAlbumQuery(VkApiClient client, UserActor actor, Long ownerId, Integer albumId,
            String title) {
        super(client, "market.editAlbum", OkResponse.class);
        accessToken(actor.getAccessToken());
        ownerId(ownerId);
        albumId(albumId);
        title(title);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketEditAlbumQuery(VkApiClient client, UserActor actor) {
        super(client, "market.editAlbum", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of an collection owner community.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public MarketEditAlbumQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Collection ID.
     *
     * @param value value of "album id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("album_id")
    public MarketEditAlbumQuery albumId(Integer value) {
        return unsafeParam("album_id", value);
    }

    /**
     * Collection title.
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public MarketEditAlbumQuery title(String value) {
        return unsafeParam("title", value);
    }

    /**
     * Cover photo id
     *
     * @param value value of "photo id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_id")
    public MarketEditAlbumQuery photoId(Integer value) {
        return unsafeParam("photo_id", value);
    }

    /**
     * Set as main ('1' - set, '0' - no).
     *
     * @param value value of "main album" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("main_album")
    public MarketEditAlbumQuery mainAlbum(Boolean value) {
        return unsafeParam("main_album", value);
    }

    /**
     * Set as hidden
     *
     * @param value value of "is hidden" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("is_hidden")
    public MarketEditAlbumQuery isHidden(Boolean value) {
        return unsafeParam("is_hidden", value);
    }

    @Override
    protected MarketEditAlbumQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("album_id", "title", "owner_id", "access_token");
    }
}
