// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.editPropertyVariant method
 */
public class MarketEditPropertyVariantQuery extends AbstractQueryBuilder<MarketEditPropertyVariantQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @param variantId value of "variant id" parameter. Minimum is 0.
     * @param title value of "title" parameter.
     */
    public MarketEditPropertyVariantQuery(VkApiClient client, UserActor actor, Long groupId,
            Integer variantId, String title) {
        super(client, "market.editPropertyVariant", OkResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
        variantId(variantId);
        title(title);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketEditPropertyVariantQuery(VkApiClient client, UserActor actor) {
        super(client, "market.editPropertyVariant", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Group id.
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MarketEditPropertyVariantQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Variant id.
     *
     * @param value value of "variant id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("variant_id")
    public MarketEditPropertyVariantQuery variantId(Integer value) {
        return unsafeParam("variant_id", value);
    }

    /**
     * Variant name.
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public MarketEditPropertyVariantQuery title(String value) {
        return unsafeParam("title", value);
    }

    @Override
    protected MarketEditPropertyVariantQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "variant_id", "title", "access_token");
    }
}
