// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.edit method
 */
public class MarketEditQuery extends AbstractQueryBuilder<MarketEditQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     * @param itemId value of "item id" parameter. Minimum is 0.
     */
    public MarketEditQuery(VkApiClient client, UserActor actor, Long ownerId, Integer itemId) {
        super(client, "market.edit", OkResponse.class);
        accessToken(actor.getAccessToken());
        ownerId(ownerId);
        itemId(itemId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketEditQuery(VkApiClient client, UserActor actor) {
        super(client, "market.edit", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of an item owner community.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public MarketEditQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Item ID.
     *
     * @param value value of "item id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("item_id")
    public MarketEditQuery itemId(Integer value) {
        return unsafeParam("item_id", value);
    }

    /**
     * Item name.
     *
     * @param value value of "name" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("name")
    public MarketEditQuery name(String value) {
        return unsafeParam("name", value);
    }

    /**
     * Item description.
     *
     * @param value value of "description" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("description")
    public MarketEditQuery description(String value) {
        return unsafeParam("description", value);
    }

    /**
     * Item category ID.
     *
     * @param value value of "category id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("category_id")
    public MarketEditQuery categoryId(Integer value) {
        return unsafeParam("category_id", value);
    }

    /**
     * Item price.
     *
     * @param value value of "price" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("price")
    public MarketEditQuery price(Number value) {
        return unsafeParam("price", value);
    }

    /**
     * Set old price
     *
     * @param value value of "old price" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("old_price")
    public MarketEditQuery oldPrice(Number value) {
        return unsafeParam("old_price", value);
    }

    /**
     * Item status ('1' - deleted, '0' - not deleted).
     *
     * @param value value of "deleted" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("deleted")
    public MarketEditQuery deleted(Boolean value) {
        return unsafeParam("deleted", value);
    }

    /**
     * Cover photo ID.
     *
     * @param value value of "main photo id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("main_photo_id")
    public MarketEditQuery mainPhotoId(Integer value) {
        return unsafeParam("main_photo_id", value);
    }

    /**
     * Url for button in market item.
     *
     * @param value value of "url" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("url")
    public MarketEditQuery url(String value) {
        return unsafeParam("url", value);
    }

    /**
     * Is main in their group.
     *
     * @param value value of "is main variant" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("is_main_variant")
    public MarketEditQuery isMainVariant(Boolean value) {
        return unsafeParam("is_main_variant", value);
    }

    /**
     * Set dimension width
     *
     * @param value value of "dimension width" parameter. Maximum is 100000. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("dimension_width")
    public MarketEditQuery dimensionWidth(Integer value) {
        return unsafeParam("dimension_width", value);
    }

    /**
     * Set dimension height
     *
     * @param value value of "dimension height" parameter. Maximum is 100000. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("dimension_height")
    public MarketEditQuery dimensionHeight(Integer value) {
        return unsafeParam("dimension_height", value);
    }

    /**
     * Set dimension length
     *
     * @param value value of "dimension length" parameter. Maximum is 100000. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("dimension_length")
    public MarketEditQuery dimensionLength(Integer value) {
        return unsafeParam("dimension_length", value);
    }

    /**
     * Set weight
     *
     * @param value value of "weight" parameter. Maximum is 100000000. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("weight")
    public MarketEditQuery weight(Integer value) {
        return unsafeParam("weight", value);
    }

    /**
     * Set sku
     *
     * @param value value of "sku" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("sku")
    public MarketEditQuery sku(String value) {
        return unsafeParam("sku", value);
    }

    /**
     * Set stock amount
     *
     * @param value value of "stock amount" parameter. Maximum is 999999. Minimum is -1.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("stock_amount")
    public MarketEditQuery stockAmount(Integer value) {
        return unsafeParam("stock_amount", value);
    }

    /**
     * photoIds
     * IDs of additional photos.
     *
     * @param value value of "photo ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_ids")
    public MarketEditQuery photoIds(Integer... value) {
        return unsafeParam("photo_ids", value);
    }

    /**
     * IDs of additional photos.
     *
     * @param value value of "photo ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_ids")
    public MarketEditQuery photoIds(List<Integer> value) {
        return unsafeParam("photo_ids", value);
    }

    /**
     * videoIds
     * IDs of additional videos.
     *
     * @param value value of "video ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("video_ids")
    public MarketEditQuery videoIds(Integer... value) {
        return unsafeParam("video_ids", value);
    }

    /**
     * IDs of additional videos.
     *
     * @param value value of "video ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("video_ids")
    public MarketEditQuery videoIds(List<Integer> value) {
        return unsafeParam("video_ids", value);
    }

    /**
     * variantIds
     * IDs of properties variants.
     *
     * @param value value of "variant ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("variant_ids")
    public MarketEditQuery variantIds(Integer... value) {
        return unsafeParam("variant_ids", value);
    }

    /**
     * IDs of properties variants.
     *
     * @param value value of "variant ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("variant_ids")
    public MarketEditQuery variantIds(List<Integer> value) {
        return unsafeParam("variant_ids", value);
    }

    @Override
    protected MarketEditQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("item_id", "owner_id", "access_token");
    }
}
