// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.market.responses.GetCategoriesNewResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.filterCategories method
 */
public class MarketFilterCategoriesQueryWithNew extends AbstractQueryBuilder<MarketFilterCategoriesQueryWithNew, GetCategoriesNewResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketFilterCategoriesQueryWithNew(VkApiClient client, UserActor actor) {
        super(client, "market.filterCategories", GetCategoriesNewResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Category_id filter categories
     *
     * @param value value of "category id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("category_id")
    public MarketFilterCategoriesQueryWithNew categoryId(Integer value) {
        return unsafeParam("category_id", value);
    }

    /**
     * Query filter categories
     *
     * @param value value of "query" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("query")
    public MarketFilterCategoriesQueryWithNew query(String value) {
        return unsafeParam("query", value);
    }

    /**
     * Number of results to return.
     *
     * @param value value of "count" parameter. Maximum is 1000. Minimum is 0. By default 20.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public MarketFilterCategoriesQueryWithNew count(Integer value) {
        return unsafeParam("count", value);
    }

    @Override
    protected MarketFilterCategoriesQueryWithNew getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
