// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.market.responses.GetAlbumsResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.getAlbums method
 */
public class MarketGetAlbumsQuery extends AbstractQueryBuilder<MarketGetAlbumsQuery, GetAlbumsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     */
    public MarketGetAlbumsQuery(VkApiClient client, UserActor actor, Long ownerId) {
        super(client, "market.getAlbums", GetAlbumsResponse.class);
        accessToken(actor.getAccessToken());
        ownerId(ownerId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketGetAlbumsQuery(VkApiClient client, UserActor actor) {
        super(client, "market.getAlbums", GetAlbumsResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of an items owner community.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public MarketGetAlbumsQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Offset needed to return a specific subset of results.
     *
     * @param value value of "offset" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public MarketGetAlbumsQuery offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * Number of items to return.
     *
     * @param value value of "count" parameter. Maximum is 100. Minimum is 0. By default 50.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public MarketGetAlbumsQuery count(Integer value) {
        return unsafeParam("count", value);
    }

    @Override
    protected MarketGetAlbumsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("owner_id", "access_token");
    }
}
