// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.market.responses.GetGroupOrdersResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.getGroupOrders method
 */
public class MarketGetGroupOrdersQuery extends AbstractQueryBuilder<MarketGetGroupOrdersQuery, GetGroupOrdersResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketGetGroupOrdersQuery(VkApiClient client, GroupActor actor) {
        super(client, "market.getGroupOrders", GetGroupOrdersResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketGetGroupOrdersQuery(VkApiClient client, UserActor actor) {
        super(client, "market.getGroupOrders", GetGroupOrdersResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID or groups domain
     *
     * @param value value of "group id" parameter. Entity - groups
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MarketGetGroupOrdersQuery groupId(String value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set offset
     *
     * @param value value of "offset" parameter. Minimum is 0. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public MarketGetGroupOrdersQuery offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * Set count
     *
     * @param value value of "count" parameter. Maximum is 50. Minimum is 1. By default 10.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public MarketGetGroupOrdersQuery count(Integer value) {
        return unsafeParam("count", value);
    }

    @Override
    protected MarketGetGroupOrdersQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
