// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.market.responses.GetExtendedResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.get method
 */
public class MarketGetQueryWithExtended extends AbstractQueryBuilder<MarketGetQueryWithExtended, GetExtendedResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     */
    public MarketGetQueryWithExtended(VkApiClient client, UserActor actor, Long ownerId) {
        super(client, "market.get", GetExtendedResponse.class);
        accessToken(actor.getAccessToken());
        ownerId(ownerId);
        extended(true);
    }

    /**
     * ID of an item owner community, "Note that community id in the 'owner_id' parameter should be negative number. For example 'owner_id'=-1 matches the [vk.com/apiclub|VK API] community "
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public MarketGetQueryWithExtended ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Set album id
     *
     * @param value value of "album id" parameter. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("album_id")
    public MarketGetQueryWithExtended albumId(Integer value) {
        return unsafeParam("album_id", value);
    }

    /**
     * Number of items to return.
     *
     * @param value value of "count" parameter. Maximum is 200. Minimum is 0. By default 100.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public MarketGetQueryWithExtended count(Integer value) {
        return unsafeParam("count", value);
    }

    /**
     * Offset needed to return a specific subset of results.
     *
     * @param value value of "offset" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public MarketGetQueryWithExtended offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * '1' - method will return additional fields: 'likes, can_comment, car_repost, photos'. These parameters are not returned by default.
     *
     * @param value value of "extended" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("extended")
    protected MarketGetQueryWithExtended extended(Boolean value) {
        return unsafeParam("extended", value);
    }

    /**
     * Items update date from (format: yyyy-mm-dd)
     *
     * @param value value of "date from" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("date_from")
    public MarketGetQueryWithExtended dateFrom(String value) {
        return unsafeParam("date_from", value);
    }

    /**
     * Items update date to (format: yyyy-mm-dd)
     *
     * @param value value of "date to" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("date_to")
    public MarketGetQueryWithExtended dateTo(String value) {
        return unsafeParam("date_to", value);
    }

    /**
     * Add variants to response if exist
     *
     * @param value value of "need variants" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("need_variants")
    public MarketGetQueryWithExtended needVariants(Boolean value) {
        return unsafeParam("need_variants", value);
    }

    /**
     * Add disabled items to response
     *
     * @param value value of "with disabled" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("with_disabled")
    public MarketGetQueryWithExtended withDisabled(Boolean value) {
        return unsafeParam("with_disabled", value);
    }

    @Override
    protected MarketGetQueryWithExtended getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("owner_id", "access_token");
    }
}
