// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.market.SearchRev;
import com.vk.api.sdk.objects.market.SearchSort;
import com.vk.api.sdk.objects.market.responses.SearchResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.search method
 */
public class MarketSearchQuery extends AbstractQueryBuilder<MarketSearchQuery, SearchResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param ownerId value of "owner id" parameter. Entity - owner
     *
     */
    public MarketSearchQuery(VkApiClient client, UserActor actor, Long ownerId) {
        super(client, "market.search", SearchResponse.class);
        accessToken(actor.getAccessToken());
        ownerId(ownerId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketSearchQuery(VkApiClient client, UserActor actor) {
        super(client, "market.search", SearchResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * ID of an items owner community.
     *
     * @param value value of "owner id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("owner_id")
    public MarketSearchQuery ownerId(Long value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Set album id
     *
     * @param value value of "album id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("album_id")
    public MarketSearchQuery albumId(Integer value) {
        return unsafeParam("album_id", value);
    }

    /**
     * Search query, for example "pink slippers".
     *
     * @param value value of "q" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("q")
    public MarketSearchQuery q(String value) {
        return unsafeParam("q", value);
    }

    /**
     * Minimum item price value.
     *
     * @param value value of "price from" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("price_from")
    public MarketSearchQuery priceFrom(Integer value) {
        return unsafeParam("price_from", value);
    }

    /**
     * Maximum item price value.
     *
     * @param value value of "price to" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("price_to")
    public MarketSearchQuery priceTo(Integer value) {
        return unsafeParam("price_to", value);
    }

    /**
     * Set sort
     *
     * @param value value of "sort" parameter. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("sort")
    public MarketSearchQuery sort(SearchSort value) {
        return unsafeParam("sort", value);
    }

    /**
     * '0' - do not use reverse order, '1' - use reverse order
     *
     * @param value value of "rev" parameter. Minimum is 0. By default 1.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("rev")
    public MarketSearchQuery rev(SearchRev value) {
        return unsafeParam("rev", value);
    }

    /**
     * Offset needed to return a specific subset of results.
     *
     * @param value value of "offset" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public MarketSearchQuery offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * Number of items to return.
     *
     * @param value value of "count" parameter. Maximum is 200. Minimum is 0. By default 20.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public MarketSearchQuery count(Integer value) {
        return unsafeParam("count", value);
    }

    /**
     * '1' - to return additional fields: 'likes, can_comment, car_repost, photos'. By default: '0'.
     *
     * @param value value of "extended" parameter. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("extended")
    public MarketSearchQuery extended(Boolean value) {
        return unsafeParam("extended", value);
    }

    /**
     * Add variants to response if exist
     *
     * @param value value of "need variants" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("need_variants")
    public MarketSearchQuery needVariants(Boolean value) {
        return unsafeParam("need_variants", value);
    }

    /**
     * status
     * Set status
     *
     * @param value value of "status" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("status")
    public MarketSearchQuery status(Integer... value) {
        return unsafeParam("status", value);
    }

    /**
     * Set status
     *
     * @param value value of "status" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("status")
    public MarketSearchQuery status(List<Integer> value) {
        return unsafeParam("status", value);
    }

    @Override
    protected MarketSearchQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("owner_id", "access_token");
    }
}
