// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.market;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Market.ungroupItems method
 */
public class MarketUngroupItemsQuery extends AbstractQueryBuilder<MarketUngroupItemsQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param groupId value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @param itemGroupId value of "item group id" parameter. Minimum is 0.
     */
    public MarketUngroupItemsQuery(VkApiClient client, UserActor actor, Long groupId,
            Integer itemGroupId) {
        super(client, "market.ungroupItems", OkResponse.class);
        accessToken(actor.getAccessToken());
        groupId(groupId);
        itemGroupId(itemGroupId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MarketUngroupItemsQuery(VkApiClient client, UserActor actor) {
        super(client, "market.ungroupItems", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Group id.
     *
     * @param value value of "group id" parameter. Minimum is 1. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MarketUngroupItemsQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Items group id.
     *
     * @param value value of "item group id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("item_group_id")
    public MarketUngroupItemsQuery itemGroupId(Integer value) {
        return unsafeParam("item_group_id", value);
    }

    @Override
    protected MarketUngroupItemsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("group_id", "access_token", "item_group_id");
    }
}
