// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.messages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.messages.responses.AddChatUsersResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Messages.addChatUsers method
 */
public class MessagesAddChatUsersQuery extends AbstractQueryBuilder<MessagesAddChatUsersQuery, AddChatUsersResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesAddChatUsersQuery(VkApiClient client, UserActor actor) {
        super(client, "messages.addChatUsers", AddChatUsersResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Set chat id
     *
     * @param value value of "chat id" parameter. Maximum is 100000000. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("chat_id")
    public MessagesAddChatUsersQuery chatId(Long value) {
        return unsafeParam("chat_id", value);
    }

    /**
     * Set visible messages count
     *
     * @param value value of "visible messages count" parameter. Maximum is 1000. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("visible_messages_count")
    public MessagesAddChatUsersQuery visibleMessagesCount(Integer value) {
        return unsafeParam("visible_messages_count", value);
    }

    @Override
    protected MessagesAddChatUsersQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
