// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.messages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.messages.responses.CreateChatWithPeerIdsResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Messages.createChat method
 */
public class MessagesCreateChatQueryWithWithpeerids extends AbstractQueryBuilder<MessagesCreateChatQueryWithWithpeerids, CreateChatWithPeerIdsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesCreateChatQueryWithWithpeerids(VkApiClient client, GroupActor actor) {
        super(client, "messages.createChat", CreateChatWithPeerIdsResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesCreateChatQueryWithWithpeerids(VkApiClient client, UserActor actor) {
        super(client, "messages.createChat", CreateChatWithPeerIdsResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Chat title.
     *
     * @param value value of "title" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("title")
    public MessagesCreateChatQueryWithWithpeerids title(String value) {
        return unsafeParam("title", value);
    }

    /**
     * Set group id
     *
     * @param value value of "group id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MessagesCreateChatQueryWithWithpeerids groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * userIds
     * IDs of the users to be added to the chat.
     *
     * @param value value of "user ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_ids")
    public MessagesCreateChatQueryWithWithpeerids userIds(Long... value) {
        return unsafeParam("user_ids", value);
    }

    /**
     * IDs of the users to be added to the chat.
     *
     * @param value value of "user ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_ids")
    public MessagesCreateChatQueryWithWithpeerids userIds(List<Long> value) {
        return unsafeParam("user_ids", value);
    }

    @Override
    protected MessagesCreateChatQueryWithWithpeerids getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
