// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.messages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.messages.responses.GetByConversationMessageIdExtendedResponse;
import com.vk.api.sdk.objects.users.Fields;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Messages.getByConversationMessageId method
 */
public class MessagesGetByConversationMessageIdQueryWithExtended extends AbstractQueryBuilder<MessagesGetByConversationMessageIdQueryWithExtended, GetByConversationMessageIdExtendedResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param peerId value of "peer id" parameter. Entity - peer
     *
     * @param conversationMessageIds value of "conversation message ids" parameter.
     */
    public MessagesGetByConversationMessageIdQueryWithExtended(VkApiClient client, GroupActor actor,
            Long peerId, Integer... conversationMessageIds) {
        super(client, "messages.getByConversationMessageId", GetByConversationMessageIdExtendedResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
        peerId(peerId);
        conversationMessageIds(conversationMessageIds);
        extended(true);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param peerId value of "peer id" parameter. Entity - peer
     *
     * @param conversationMessageIds value of "conversation message ids" parameter.
     */
    public MessagesGetByConversationMessageIdQueryWithExtended(VkApiClient client, GroupActor actor,
            Long peerId, List<Integer> conversationMessageIds) {
        super(client, "messages.getByConversationMessageId", GetByConversationMessageIdExtendedResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
        peerId(peerId);
        conversationMessageIds(conversationMessageIds);
        extended(true);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param peerId value of "peer id" parameter. Entity - peer
     *
     * @param conversationMessageIds value of "conversation message ids" parameter.
     */
    public MessagesGetByConversationMessageIdQueryWithExtended(VkApiClient client, UserActor actor,
            Long peerId, Integer... conversationMessageIds) {
        super(client, "messages.getByConversationMessageId", GetByConversationMessageIdExtendedResponse.class);
        accessToken(actor.getAccessToken());
        peerId(peerId);
        conversationMessageIds(conversationMessageIds);
        extended(true);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param peerId value of "peer id" parameter. Entity - peer
     *
     * @param conversationMessageIds value of "conversation message ids" parameter.
     */
    public MessagesGetByConversationMessageIdQueryWithExtended(VkApiClient client, UserActor actor,
            Long peerId, List<Integer> conversationMessageIds) {
        super(client, "messages.getByConversationMessageId", GetByConversationMessageIdExtendedResponse.class);
        accessToken(actor.getAccessToken());
        peerId(peerId);
        conversationMessageIds(conversationMessageIds);
        extended(true);
    }

    /**
     * Destination ID. "For user: 'User ID', e.g. '12345'. For chat: '2000000000' + 'chat_id', e.g. '2000000001'. For community: '- community ID', e.g. '-12345'. "
     *
     * @param value value of "peer id" parameter. Entity - peer
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("peer_id")
    public MessagesGetByConversationMessageIdQueryWithExtended peerId(Long value) {
        return unsafeParam("peer_id", value);
    }

    /**
     * Information whether the response should be extended
     *
     * @param value value of "extended" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("extended")
    protected MessagesGetByConversationMessageIdQueryWithExtended extended(Boolean value) {
        return unsafeParam("extended", value);
    }

    /**
     * Group ID (for group messages with group access token)
     *
     * @param value value of "group id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MessagesGetByConversationMessageIdQueryWithExtended groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * conversationMessageIds
     * Conversation message IDs.
     *
     * @param value value of "conversation message ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("conversation_message_ids")
    public MessagesGetByConversationMessageIdQueryWithExtended conversationMessageIds(
            Integer... value) {
        return unsafeParam("conversation_message_ids", value);
    }

    /**
     * Conversation message IDs.
     *
     * @param value value of "conversation message ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("conversation_message_ids")
    public MessagesGetByConversationMessageIdQueryWithExtended conversationMessageIds(
            List<Integer> value) {
        return unsafeParam("conversation_message_ids", value);
    }

    /**
     * fields
     * Profile fields to return.
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fields")
    public MessagesGetByConversationMessageIdQueryWithExtended fields(Fields... value) {
        return unsafeParam("fields", value);
    }

    /**
     * Profile fields to return.
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fields")
    public MessagesGetByConversationMessageIdQueryWithExtended fields(List<Fields> value) {
        return unsafeParam("fields", value);
    }

    @Override
    protected MessagesGetByConversationMessageIdQueryWithExtended getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("peer_id", "conversation_message_ids", "access_token");
    }
}
