// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.messages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.messages.GetHistoryAttachmentsMediaType;
import com.vk.api.sdk.objects.messages.responses.GetHistoryAttachmentsResponse;
import com.vk.api.sdk.objects.users.Fields;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Messages.getHistoryAttachments method
 */
public class MessagesGetHistoryAttachmentsQuery extends AbstractQueryBuilder<MessagesGetHistoryAttachmentsQuery, GetHistoryAttachmentsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesGetHistoryAttachmentsQuery(VkApiClient client, GroupActor actor) {
        super(client, "messages.getHistoryAttachments", GetHistoryAttachmentsResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesGetHistoryAttachmentsQuery(VkApiClient client, UserActor actor) {
        super(client, "messages.getHistoryAttachments", GetHistoryAttachmentsResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Group ID (for group messages with group access token)
     *
     * @param value value of "group id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MessagesGetHistoryAttachmentsQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Peer ID. ", For group chat: '2000000000 + chat ID' , , For community: '-community ID'"
     *
     * @param value value of "peer id" parameter. Entity - peer
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("peer_id")
    public MessagesGetHistoryAttachmentsQuery peerId(Long value) {
        return unsafeParam("peer_id", value);
    }

    /**
     * Set cmid
     *
     * @param value value of "cmid" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("cmid")
    public MessagesGetHistoryAttachmentsQuery cmid(Integer value) {
        return unsafeParam("cmid", value);
    }

    /**
     * Set attachment position
     *
     * @param value value of "attachment position" parameter. Maximum is 200. Minimum is 1.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("attachment_position")
    public MessagesGetHistoryAttachmentsQuery attachmentPosition(Integer value) {
        return unsafeParam("attachment_position", value);
    }

    /**
     * Set offset
     *
     * @param value value of "offset" parameter. Maximum is 200. Minimum is -200.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("offset")
    public MessagesGetHistoryAttachmentsQuery offset(Integer value) {
        return unsafeParam("offset", value);
    }

    /**
     * Number of objects to return.
     *
     * @param value value of "count" parameter. Maximum is 200. Minimum is 0. By default 30.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("count")
    public MessagesGetHistoryAttachmentsQuery count(Integer value) {
        return unsafeParam("count", value);
    }

    /**
     * Set extended
     *
     * @param value value of "extended" parameter. By default false.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("extended")
    public MessagesGetHistoryAttachmentsQuery extended(Boolean value) {
        return unsafeParam("extended", value);
    }

    /**
     * Set max forwards level
     *
     * @param value value of "max forwards level" parameter. Maximum is 45. Minimum is 0. By default 45.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("max_forwards_level")
    public MessagesGetHistoryAttachmentsQuery maxForwardsLevel(Integer value) {
        return unsafeParam("max_forwards_level", value);
    }

    /**
     * Type of media files to return: *'photo',, *'video',, *'audio',, *'doc',, *'link'.,*'market'.,*'wall'.,*'share'
     *
     * @param value value of "media type" parameter. By default photo.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("media_type")
    public MessagesGetHistoryAttachmentsQuery mediaType(GetHistoryAttachmentsMediaType value) {
        return unsafeParam("media_type", value);
    }

    /**
     * Message ID to start return results from.
     *
     * @param value value of "start from" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("start_from")
    public MessagesGetHistoryAttachmentsQuery startFrom(String value) {
        return unsafeParam("start_from", value);
    }

    /**
     * Set preserve order
     *
     * @param value value of "preserve order" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("preserve_order")
    public MessagesGetHistoryAttachmentsQuery preserveOrder(Boolean value) {
        return unsafeParam("preserve_order", value);
    }

    /**
     * '1' - to return photo sizes in a
     *
     * @param value value of "photo sizes" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("photo_sizes")
    public MessagesGetHistoryAttachmentsQuery photoSizes(Boolean value) {
        return unsafeParam("photo_sizes", value);
    }

    /**
     * attachmentTypes
     * Set attachment types
     *
     * @param value value of "attachment types" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("attachment_types")
    public MessagesGetHistoryAttachmentsQuery attachmentTypes(String... value) {
        return unsafeParam("attachment_types", value);
    }

    /**
     * Set attachment types
     *
     * @param value value of "attachment types" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("attachment_types")
    public MessagesGetHistoryAttachmentsQuery attachmentTypes(List<String> value) {
        return unsafeParam("attachment_types", value);
    }

    /**
     * fields
     * Additional profile [vk.com/dev/fields|fields] to return.
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fields")
    public MessagesGetHistoryAttachmentsQuery fields(Fields... value) {
        return unsafeParam("fields", value);
    }

    /**
     * Additional profile [vk.com/dev/fields|fields] to return.
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("fields")
    public MessagesGetHistoryAttachmentsQuery fields(List<Fields> value) {
        return unsafeParam("fields", value);
    }

    @Override
    protected MessagesGetHistoryAttachmentsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
