// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.messages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.messages.responses.GetLastActivityResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Messages.getLastActivity method
 */
public class MessagesGetLastActivityQuery extends AbstractQueryBuilder<MessagesGetLastActivityQuery, GetLastActivityResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     * @param userId value of "user id" parameter. Entity - owner
     *
     */
    public MessagesGetLastActivityQuery(VkApiClient client, UserActor actor, Long userId) {
        super(client, "messages.getLastActivity", GetLastActivityResponse.class);
        accessToken(actor.getAccessToken());
        userId(userId);
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesGetLastActivityQuery(VkApiClient client, UserActor actor) {
        super(client, "messages.getLastActivity", GetLastActivityResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * User ID.
     *
     * @param value value of "user id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public MessagesGetLastActivityQuery userId(Long value) {
        return unsafeParam("user_id", value);
    }

    @Override
    protected MessagesGetLastActivityQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("user_id", "access_token");
    }
}
