// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.messages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.base.responses.OkResponse;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Messages.markAsRead method
 */
public class MessagesMarkAsReadQuery extends AbstractQueryBuilder<MessagesMarkAsReadQuery, OkResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesMarkAsReadQuery(VkApiClient client, GroupActor actor) {
        super(client, "messages.markAsRead", OkResponse.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesMarkAsReadQuery(VkApiClient client, UserActor actor) {
        super(client, "messages.markAsRead", OkResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Destination ID. "For user: 'User ID', e.g. '12345'. For chat: '2000000000' + 'chat_id', e.g. '2000000001'. For community: '- community ID', e.g. '-12345'. "
     *
     * @param value value of "peer id" parameter. Entity - peer
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("peer_id")
    public MessagesMarkAsReadQuery peerId(Long value) {
        return unsafeParam("peer_id", value);
    }

    /**
     * Message ID to start from.
     *
     * @param value value of "start message id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("start_message_id")
    public MessagesMarkAsReadQuery startMessageId(Integer value) {
        return unsafeParam("start_message_id", value);
    }

    /**
     * Group ID (for group messages with user access token)
     *
     * @param value value of "group id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MessagesMarkAsReadQuery groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set mark conversation as read
     *
     * @param value value of "mark conversation as read" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("mark_conversation_as_read")
    public MessagesMarkAsReadQuery markConversationAsRead(Boolean value) {
        return unsafeParam("mark_conversation_as_read", value);
    }

    /**
     * Set up to cmid
     *
     * @param value value of "up to cmid" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("up_to_cmid")
    public MessagesMarkAsReadQuery upToCmid(Integer value) {
        return unsafeParam("up_to_cmid", value);
    }

    /**
     * messageIds
     * IDs of messages to mark as read.
     *
     * @param value value of "message ids" parameter. By default [].
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_ids")
    public MessagesMarkAsReadQuery messageIds(Integer... value) {
        return unsafeParam("message_ids", value);
    }

    /**
     * IDs of messages to mark as read.
     *
     * @param value value of "message ids" parameter. By default [].
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message_ids")
    public MessagesMarkAsReadQuery messageIds(List<Integer> value) {
        return unsafeParam("message_ids", value);
    }

    @Override
    protected MessagesMarkAsReadQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
