// Autogenerated from vk-api-schema. Please don't edit it manually.
package com.vk.api.sdk.queries.messages;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.GroupActor;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.annotations.ApiParam;
import com.vk.api.sdk.objects.messages.Forward;
import com.vk.api.sdk.objects.messages.Keyboard;
import com.vk.api.sdk.objects.messages.SendIntent;
import java.util.Arrays;
import java.util.List;

/**
 * Query for Messages.send method
 */
public class MessagesSendQueryWithDeprecated extends AbstractQueryBuilder<MessagesSendQueryWithDeprecated, Integer> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build group api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesSendQueryWithDeprecated(VkApiClient client, GroupActor actor) {
        super(client, "messages.send", Integer.class);
        accessToken(actor.getAccessToken());
        groupId(actor.getGroupId());
    }

    /**
     * Creates a AbstractQueryBuilder instance that can be used to build user api request with various parameters
     *
     * @param client VK API client
     * @param actor actor with access token
     */
    public MessagesSendQueryWithDeprecated(VkApiClient client, UserActor actor) {
        super(client, "messages.send", Integer.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * User ID (by default - current user).
     *
     * @param value value of "user id" parameter. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("user_id")
    public MessagesSendQueryWithDeprecated userId(Long value) {
        return unsafeParam("user_id", value);
    }

    /**
     * Unique identifier to avoid resending the message.
     *
     * @param value value of "random id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("random_id")
    public MessagesSendQueryWithDeprecated randomId(Integer value) {
        return unsafeParam("random_id", value);
    }

    /**
     * Destination ID. "For user: 'User ID', e.g. '12345'. For chat: '2000000000' + 'chat_id', e.g. '2000000001'. For community: '- community ID', e.g. '-12345'. "
     *
     * @param value value of "peer id" parameter. Entity - peer
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("peer_id")
    public MessagesSendQueryWithDeprecated peerId(Long value) {
        return unsafeParam("peer_id", value);
    }

    /**
     * User's short address (for example, 'illarionov').
     *
     * @param value value of "domain" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("domain")
    public MessagesSendQueryWithDeprecated domain(String value) {
        return unsafeParam("domain", value);
    }

    /**
     * ID of conversation the message will relate to.
     *
     * @param value value of "chat id" parameter. Maximum is 100000000. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("chat_id")
    public MessagesSendQueryWithDeprecated chatId(Integer value) {
        return unsafeParam("chat_id", value);
    }

    /**
     * (Required if 'attachments' is not set.) Text of the message.
     *
     * @param value value of "message" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("message")
    public MessagesSendQueryWithDeprecated message(String value) {
        return unsafeParam("message", value);
    }

    /**
     * Geographical latitude of a check-in, in degrees (from -90 to 90).
     *
     * @param value value of "lat" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("lat")
    public MessagesSendQueryWithDeprecated lat(Number value) {
        return unsafeParam("lat", value);
    }

    /**
     * Geographical longitude of a check-in, in degrees (from -180 to 180).
     *
     * @param value value of "long" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("long")
    public MessagesSendQueryWithDeprecated lng(Number value) {
        return unsafeParam("long", value);
    }

    /**
     * (Required if 'message' is not set.) List of objects attached to the message, separated by commas, in the following format: "<owner_id>_<media_id>", ' - Type of media attachment: 'photo' - photo, 'video' - video, 'audio' - audio, 'doc' - document, 'wall' - wall post, '<owner_id>' - ID of the media attachment owner. '<media_id>' - media attachment ID. Example: "photo100172_166443618"
     *
     * @param value value of "attachment" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("attachment")
    public MessagesSendQueryWithDeprecated attachment(String value) {
        return unsafeParam("attachment", value);
    }

    /**
     * Set reply to
     *
     * @param value value of "reply to" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("reply_to")
    public MessagesSendQueryWithDeprecated replyTo(Integer value) {
        return unsafeParam("reply_to", value);
    }

    /**
     * JSON describing the forwarded message or reply
     *
     * @param value value of "forward" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("forward")
    public MessagesSendQueryWithDeprecated forward(Forward value) {
        return unsafeParam("forward", value);
    }

    /**
     * Sticker id.
     *
     * @param value value of "sticker id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("sticker_id")
    public MessagesSendQueryWithDeprecated stickerId(Integer value) {
        return unsafeParam("sticker_id", value);
    }

    /**
     * Group ID (for group messages with group access token)
     *
     * @param value value of "group id" parameter. Minimum is 0. Entity - owner
     *
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("group_id")
    public MessagesSendQueryWithDeprecated groupId(Long value) {
        return unsafeParam("group_id", value);
    }

    /**
     * Set keyboard
     *
     * @param value value of "keyboard" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("keyboard")
    public MessagesSendQueryWithDeprecated keyboard(Keyboard value) {
        return unsafeParam("keyboard", value);
    }

    /**
     * Set template
     *
     * @param value value of "template" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("template")
    public MessagesSendQueryWithDeprecated template(String value) {
        return unsafeParam("template", value);
    }

    /**
     * Set payload
     *
     * @param value value of "payload" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("payload")
    public MessagesSendQueryWithDeprecated payload(String value) {
        return unsafeParam("payload", value);
    }

    /**
     * JSON describing the content source in the message
     *
     * @param value value of "content source" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("content_source")
    public MessagesSendQueryWithDeprecated contentSource(String value) {
        return unsafeParam("content_source", value);
    }

    /**
     * Set dont parse links
     *
     * @param value value of "dont parse links" parameter. By default false.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("dont_parse_links")
    public MessagesSendQueryWithDeprecated dontParseLinks(Boolean value) {
        return unsafeParam("dont_parse_links", value);
    }

    /**
     * Set disable mentions
     *
     * @param value value of "disable mentions" parameter. By default false.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("disable_mentions")
    public MessagesSendQueryWithDeprecated disableMentions(Boolean value) {
        return unsafeParam("disable_mentions", value);
    }

    /**
     * Set intent
     *
     * @param value value of "intent" parameter. By default default.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("intent")
    public MessagesSendQueryWithDeprecated intent(SendIntent value) {
        return unsafeParam("intent", value);
    }

    /**
     * Set subscribe id
     *
     * @param value value of "subscribe id" parameter. Maximum is 100. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("subscribe_id")
    public MessagesSendQueryWithDeprecated subscribeId(Integer value) {
        return unsafeParam("subscribe_id", value);
    }

    /**
     * peerIds
     * IDs of message recipients. (See peer_id)
     *
     * @param value value of "peer ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("peer_ids")
    public MessagesSendQueryWithDeprecated peerIds(Long... value) {
        return unsafeParam("peer_ids", value);
    }

    /**
     * IDs of message recipients. (See peer_id)
     *
     * @param value value of "peer ids" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("peer_ids")
    public MessagesSendQueryWithDeprecated peerIds(List<Long> value) {
        return unsafeParam("peer_ids", value);
    }

    /**
     * forwardMessages
     * ID of forwarded messages, separated with a comma. Listed messages of the sender will be shown in the message body at the recipient's. Example: "123,431,544"
     *
     * @param value value of "forward messages" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("forward_messages")
    public MessagesSendQueryWithDeprecated forwardMessages(Integer... value) {
        return unsafeParam("forward_messages", value);
    }

    /**
     * ID of forwarded messages, separated with a comma. Listed messages of the sender will be shown in the message body at the recipient's. Example: "123,431,544"
     *
     * @param value value of "forward messages" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    @ApiParam("forward_messages")
    public MessagesSendQueryWithDeprecated forwardMessages(List<Integer> value) {
        return unsafeParam("forward_messages", value);
    }

    @Override
    protected MessagesSendQueryWithDeprecated getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
